/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.tools.ClassVersionInfo;

public class SerialVersionUID {
    static Logger log = Logger.getLogger("SerialVersionUID");

    static void buildJarSet(File dir, HashSet jarFiles) throws MalformedURLException {
        File[] files = dir.listFiles();
        int count = files != null ? files.length : 0;
        System.out.println("Checking dir: " + dir + ", count=" + count);
        for (int n = 0; n < count; ++n) {
            File child = files[n];
            if (child.isDirectory() && !child.getName().equals("tmp")) {
                SerialVersionUID.buildJarSet(child, jarFiles);
                continue;
            }
            if (!child.getName().endsWith(".jar")) continue;
            jarFiles.add(child.toURL());
        }
    }

    static void generateJarSerialVersionUIDs(URL jar, TreeMap classVersionMap, ClassLoader cl, String pkgPrefix) throws IOException {
        String jarName = jar.getFile();
        JarFile jf = new JarFile(jarName);
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".class") || !name.startsWith(pkgPrefix)) continue;
            name = name.substring(0, name.length() - 6);
            String classname = name.replace('/', '.');
            try {
                log.fine("Creating ClassVersionInfo for: " + classname);
                ClassVersionInfo cvi = new ClassVersionInfo(classname, cl);
                log.fine(cvi.toString());
                if (cvi.getSerialVersion() == 0L) continue;
                ClassVersionInfo prevCVI = classVersionMap.put(classname, cvi);
                if (prevCVI != null && prevCVI.getSerialVersion() != cvi.getSerialVersion()) {
                    log.severe("Found inconsistent classes, " + prevCVI + " != " + cvi + ", jar: " + jarName);
                }
                if (cvi.getHasExplicitSerialVersionUID()) continue;
                log.warning("No explicit serialVersionUID: " + cvi);
            }
            catch (OutOfMemoryError e) {
                log.log(Level.SEVERE, "Check the MaxPermSize", e);
            }
            catch (Throwable e) {
                log.log(Level.FINE, "While loading: " + name, e);
            }
        }
        jf.close();
    }

    public static Map generateJBossSerialVersionUIDReport(File jbossHome) throws IOException {
        HashSet jarFiles = new HashSet();
        File lib = new File(jbossHome, "lib");
        SerialVersionUID.buildJarSet(lib, jarFiles);
        File all = new File(jbossHome, "server/all");
        SerialVersionUID.buildJarSet(all, jarFiles);
        URL[] cp = new URL[jarFiles.size()];
        jarFiles.toArray(cp);
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        URLClassLoader completeClasspath = new URLClassLoader(cp, parent);
        TreeMap classVersionMap = new TreeMap();
        for (URL jar : jarFiles) {
            try {
                SerialVersionUID.generateJarSerialVersionUIDs(jar, classVersionMap, completeClasspath, "");
            }
            catch (IOException e) {
                log.info("Failed to process jar: " + jar);
            }
        }
        return classVersionMap;
    }

    public static Map generateRISerialVersionUIDReport(File j2eeHome) throws IOException {
        HashSet jarFiles = new HashSet();
        File lib = new File(j2eeHome, "lib");
        SerialVersionUID.buildJarSet(lib, jarFiles);
        URL[] cp = new URL[jarFiles.size()];
        jarFiles.toArray(cp);
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        URLClassLoader completeClasspath = new URLClassLoader(cp, parent);
        TreeMap classVersionMap = new TreeMap();
        for (URL jar : jarFiles) {
            try {
                SerialVersionUID.generateJarSerialVersionUIDs(jar, classVersionMap, completeClasspath, "javax");
            }
            catch (IOException e) {
                log.info("Failed to process jar: " + jar);
            }
        }
        return classVersionMap;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: jboss-home | -rihome ri-home");
            System.exit(1);
        }
        File distHome = new File(args[0]);
        Map classVersionMap = null;
        classVersionMap = args.length == 2 ? SerialVersionUID.generateRISerialVersionUIDReport(distHome) : SerialVersionUID.generateJBossSerialVersionUIDReport(distHome);
        log.info("Total classes with serialVersionUID != 0: " + classVersionMap.size());
        FileOutputStream fos = new FileOutputStream("serialuid.ser");
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(classVersionMap);
        fos.close();
    }
}

