/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding.impl;

import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.services.binding.DuplicateServiceException;
import org.jboss.services.binding.NoSuchBindingException;
import org.jboss.services.binding.ServiceBinding;
import org.jboss.services.binding.ServiceBindingMetadata;
import org.jboss.services.binding.ServiceBindingStore;
import org.jboss.services.binding.impl.ServiceBindingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementObject(name="PojoServiceBindingStore", type="ServiceBindingStore", componentType=@ManagementComponent(type="MCBean", subtype="ServiceBindingStore"), properties=ManagementProperties.EXPLICIT)
public class PojoServiceBindingStore
implements ServiceBindingStore {
    private static final Object VALUE = new Object();
    private final ConcurrentMap<ServiceBindingKey, ServiceBinding> bindings = new ConcurrentHashMap<ServiceBindingKey, ServiceBinding>(16, 0.75f, 2);
    private final ConcurrentMap<String, ServiceBindingSet> bindingSets = new ConcurrentHashMap<String, ServiceBindingSet>(16, 0.75f, 2);
    private final Map<ServiceBindingMetadata, Object> standardBindings = new ConcurrentHashMap<ServiceBindingMetadata, Object>(16, 0.75f, 2);
    private boolean started;

    @Override
    public void addServiceBinding(String serverName, ServiceBindingMetadata metadata) throws DuplicateServiceException, UnknownHostException {
        this.validateServerName(serverName);
        ServiceBindingSet bindingSet = (ServiceBindingSet)this.bindingSets.get(serverName);
        ServiceBinding binding = new ServiceBinding(metadata, bindingSet.getDefaultHostName(), bindingSet.getPortOffset());
        ServiceBinding oldBinding = this.bindings.putIfAbsent(new ServiceBindingKey(serverName, metadata), binding);
        if (!(oldBinding == null || PojoServiceBindingStore.safeEquals(oldBinding.getHostName(), binding.getHostName()) && oldBinding.getPort() == binding.getPort())) {
            throw new DuplicateServiceException(serverName, binding);
        }
        bindingSet.getOverrideBindings().add(metadata);
    }

    @Override
    public ServiceBinding getServiceBinding(String serverName, String serviceName, String bindingName) throws NoSuchBindingException {
        ServiceBinding binding = (ServiceBinding)this.bindings.get(new ServiceBindingKey(serverName, serviceName, bindingName));
        if (binding == null) {
            throw new NoSuchBindingException(serverName, serviceName, bindingName);
        }
        return binding;
    }

    @Override
    public Set<ServiceBinding> getServiceBindings(String serverName) {
        this.validateServerName(serverName);
        HashSet<ServiceBinding> result = new HashSet<ServiceBinding>();
        for (Map.Entry entry : this.bindings.entrySet()) {
            if (!serverName.equals(((ServiceBindingKey)entry.getKey()).serverName)) continue;
            result.add((ServiceBinding)entry.getValue());
        }
        return result;
    }

    @Override
    public void removeServiceBinding(String serverName, ServiceBindingMetadata metadata) {
        this.validateServerName(serverName);
        this.bindings.remove(new ServiceBindingKey(serverName, metadata));
        ServiceBindingSet bindingSet = (ServiceBindingSet)this.bindingSets.get(serverName);
        bindingSet.getOverrideBindings().remove(metadata);
    }

    @Override
    public String getDefaultHostName(String serverName) {
        this.validateServerName(serverName);
        return ((ServiceBindingSet)this.bindingSets.get(serverName)).getDefaultHostName();
    }

    @Override
    public int getDefaultPortOffset(String serverName) {
        this.validateServerName(serverName);
        return ((ServiceBindingSet)this.bindingSets.get(serverName)).getPortOffset();
    }

    public void setStandardBindings(Set<ServiceBindingMetadata> bindings) {
        if (this.started) {
            throw new IllegalStateException("Cannot call setPortOffsetBindings() after start()");
        }
        this.standardBindings.clear();
        if (bindings != null) {
            for (ServiceBindingMetadata binding : bindings) {
                this.standardBindings.put(binding, VALUE);
            }
        }
    }

    public void setServiceBindingSets(Set<ServiceBindingSet> sets) {
        if (this.started) {
            throw new IllegalStateException("Cannot call setServiceBindingSets() after start()");
        }
        this.bindingSets.clear();
        if (sets != null) {
            for (ServiceBindingSet bindingSet : sets) {
                this.bindingSets.put(bindingSet.getName(), bindingSet);
            }
        }
    }

    public void start() throws DuplicateServiceException, UnknownHostException {
        for (ServiceBindingSet bindingSet : this.bindingSets.values()) {
            for (ServiceBindingMetadata binding : bindingSet.getOverrideBindings()) {
                this.addServiceBinding(bindingSet.getName(), binding);
            }
        }
        for (ServiceBindingMetadata metadata : this.standardBindings.keySet()) {
            for (ServiceBindingSet bindingSet : this.bindingSets.values()) {
                try {
                    this.addServiceBinding(bindingSet.getName(), metadata);
                }
                catch (DuplicateServiceException e) {
                    if (bindingSet.getOverrideBindings().contains(metadata)) continue;
                    throw e;
                }
            }
        }
        this.started = true;
    }

    public void stop() {
        this.bindings.clear();
        this.started = false;
    }

    @ManagementProperty(description="the base set of bindings that should be associated with each binding set")
    public Set<ServiceBindingMetadata> getStandardBindings() {
        return new HashSet<ServiceBindingMetadata>(this.standardBindings.keySet());
    }

    @ManagementProperty(description="the named binding sets")
    public Set<ServiceBindingSet> getBindingSets() {
        return new HashSet<ServiceBindingSet>(this.bindingSets.values());
    }

    @ManagementOperation(description="adds a service binding", impact=ManagedOperation.Impact.WriteOnly, params={@ManagementParameter(name="binding"), @ManagementParameter(name="fixed")})
    public void addServiceBinding(ServiceBindingMetadata metadata) throws DuplicateServiceException {
        for (ServiceBindingSet bindingSet : this.bindingSets.values()) {
            try {
                this.addServiceBinding(bindingSet.getName(), metadata);
            }
            catch (UnknownHostException e) {
                String hostName = metadata.isFixedHostName() ? metadata.getHostName() : bindingSet.getDefaultHostName();
                throw new IllegalStateException("Cannot convert " + hostName + " into an InetAddress");
            }
        }
        this.standardBindings.put(metadata, VALUE);
    }

    @ManagementOperation(description="adds a service binding", impact=ManagedOperation.Impact.WriteOnly, params={@ManagementParameter(name="serviceName"), @ManagementParameter(name="bindingName"), @ManagementParameter(name="hostName"), @ManagementParameter(name="port"), @ManagementParameter(name="fixedPort")})
    public void addServiceBinding(String serviceName, String bindingName, String hostName, int port, boolean fixedPort) throws DuplicateServiceException, UnknownHostException {
        ServiceBindingMetadata metadata = new ServiceBindingMetadata();
        metadata.setServiceName(serviceName);
        metadata.setBindingName(bindingName);
        metadata.setHostName(hostName);
        metadata.setPort(port);
        metadata.setFixedPort(fixedPort);
        this.addServiceBinding(metadata);
    }

    @ManagementOperation(description="removes a service binding", impact=ManagedOperation.Impact.WriteOnly, params={@ManagementParameter(name="binding")})
    public void removeServiceBinding(ServiceBindingMetadata metadata) {
        for (String serverName : this.bindingSets.keySet()) {
            this.removeServiceBinding(serverName, metadata);
        }
        this.standardBindings.remove(metadata);
    }

    @ManagementOperation(description="removes a service binding", impact=ManagedOperation.Impact.WriteOnly, params={@ManagementParameter(name="serviceName"), @ManagementParameter(name="bindingName")})
    public void removeServiceBinding(String serviceName, String bindingName) {
        ServiceBindingMetadata metadata = new ServiceBindingMetadata(serviceName, bindingName);
        this.removeServiceBinding(metadata);
    }

    private static boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    private void validateServerName(String serverName) {
        if (!this.bindingSets.containsKey(serverName)) {
            throw new IllegalArgumentException("unknown serverName " + serverName);
        }
    }

    private static class ServiceBindingKey {
        private final String serverName;
        private final String serviceName;
        private final String bindingName;

        private ServiceBindingKey(String serverName, ServiceBindingMetadata binding) {
            if (serverName == null) {
                throw new IllegalArgumentException("serverName is null");
            }
            if (binding == null) {
                throw new IllegalArgumentException("binding is null");
            }
            if (binding.getServiceName() == null) {
                throw new IllegalStateException("binding's serviceName is null");
            }
            this.serverName = serverName;
            this.serviceName = binding.getServiceName();
            this.bindingName = binding.getBindingName();
        }

        private ServiceBindingKey(String serverName, String serviceName, String bindingName) {
            if (serverName == null) {
                throw new IllegalArgumentException("serverName is null");
            }
            if (serviceName == null) {
                throw new IllegalArgumentException("serviceName is null");
            }
            this.serverName = serverName;
            this.serviceName = ServiceBindingMetadata.canonicalizeServiceName(serviceName);
            this.bindingName = bindingName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ServiceBindingKey) {
                ServiceBindingKey other = (ServiceBindingKey)obj;
                return this.serverName.equals(other.serverName) && this.serviceName.equals(other.serviceName) && PojoServiceBindingStore.safeEquals(this.bindingName, other.bindingName);
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result += 23 * this.serverName.hashCode();
            result += 23 * this.serviceName.hashCode();
            return result += 23 * (this.bindingName == null ? 0 : this.bindingName.hashCode());
        }
    }
}

