/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.stats.report;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.varia.stats.AbstractStatisticalItem;
import org.jboss.varia.stats.CacheListener;
import org.jboss.varia.stats.TxReport;
import org.jboss.varia.stats.report.ReportGenerator;

public class CacheReportGenerator
extends ReportGenerator {
    protected void content(String reportName, StringBuffer content) throws Exception {
        boolean select;
        StringBuffer contentionBuf = new StringBuffer();
        contentionBuf.append("<table><tr><th>Lock Contention Per Table</th><th>Total time</th><th>Max time</th><th>count</th></tr>");
        int contentionTotal = 0;
        int contentionTimeTotal = 0;
        long maxContentionTime = 0L;
        StringBuffer evictionBuf = new StringBuffer();
        evictionBuf.append("<table><tr><th>Eviction per table</th><th>count</th></tr>");
        int evictionTotal = 0;
        StringBuffer hitsBuf = new StringBuffer();
        hitsBuf.append("<table><tr><th>Hits per table</th><th>count</th></tr>");
        int hitsTotal = 0;
        StringBuffer missesBuf = new StringBuffer();
        missesBuf.append("<table><tr><th>Misses per table</th><th>count</th></tr>");
        int missesTotal = 0;
        StringBuffer reportsTable = new StringBuffer();
        reportsTable.append("<table><tr><th>Transaction started by</th><th>Total</th></tr>");
        int txTotal = 0;
        HashMap<String, Contention> contention = new HashMap<String, Contention>();
        HashMap<String, Eviction> eviction = new HashMap<String, Eviction>();
        HashMap<String, Hit> hits = new HashMap<String, Hit>();
        HashMap<String, Miss> misses = new HashMap<String, Miss>();
        Iterator reports = this.getReportsIterator();
        while (reports.hasNext()) {
            TxReport report = (TxReport)reports.next();
            Map contentionMap = (Map)report.getStats().get("Cache Contention Statistics Per Transaction");
            Map evictionMap = (Map)report.getStats().get("Cache Eviction Statistics Per Transaction");
            Map hitsMap = (Map)report.getStats().get("Cache Hits Per Transaction");
            Map missesMap = (Map)report.getStats().get("Cache Misses Per Transaction");
            txTotal += report.getCount();
            if (contentionMap == null && evictionMap == null && hitsMap == null && missesMap == null) continue;
            reportsTable.append("<tr><td>");
            boolean selected = report.getName().equals(reportName);
            if (!selected) {
                reportsTable.append("<a href='HtmlAdaptor?").append("action=invokeOpByName&name=").append(this.getServiceName()).append("&methodName=generate&").append("argType=java.lang.String&arg0=").append(report.getName()).append("'>");
            }
            reportsTable.append(report.getName());
            if (!selected) {
                reportsTable.append("</a>");
            }
            reportsTable.append("</td><td>").append(report.getCount()).append("</td></tr>");
            if (!selected && reportName != null && reportName.trim().length() != 0) continue;
            if (contentionMap != null) {
                for (AbstractStatisticalItem item : contentionMap.values()) {
                    Contention c = (Contention)contention.get(item.getValue());
                    if (c == null) {
                        c = new Contention(item.getValue());
                        contention.put(c.tableName, c);
                    }
                    c.total = (int)((long)c.total + ((CacheListener.ContentionStats)item).getContentionTimeTotal());
                    c.count += item.getCount();
                    if (c.maxTime < ((CacheListener.ContentionStats)item).getMaxContentionTime()) {
                        c.maxTime = ((CacheListener.ContentionStats)item).getMaxContentionTime();
                    }
                    contentionTotal += item.getCount();
                    contentionTimeTotal = (int)((long)contentionTimeTotal + ((CacheListener.ContentionStats)item).getContentionTimeTotal());
                    if (((CacheListener.ContentionStats)item).getMaxContentionTime() <= maxContentionTime) continue;
                    maxContentionTime = ((CacheListener.ContentionStats)item).getMaxContentionTime();
                }
            }
            if (evictionMap != null) {
                for (AbstractStatisticalItem item : evictionMap.values()) {
                    Eviction e = (Eviction)eviction.get(((CacheListener.EvictionStats)item).getTableName());
                    if (e == null) {
                        e = new Eviction(((CacheListener.EvictionStats)item).getTableName());
                        eviction.put(e.tableName, e);
                    }
                    e.count += item.getCount();
                    evictionTotal += item.getCount();
                }
            }
            if (hitsMap != null) {
                for (AbstractStatisticalItem item : hitsMap.values()) {
                    Hit h = (Hit)hits.get(((CacheListener.HitStats)item).getTableName());
                    if (h == null) {
                        h = new Hit(((CacheListener.HitStats)item).getTableName());
                        hits.put(h.tableName, h);
                    }
                    h.partitionHit(((CacheListener.HitStats)item).getPartitionIndex(), item.getCount());
                    hitsTotal += item.getCount();
                }
            }
            if (missesMap == null) continue;
            for (AbstractStatisticalItem item : missesMap.values()) {
                Miss m = (Miss)misses.get(item.getValue());
                if (m == null) {
                    m = new Miss(item.getValue());
                    misses.put(m.tableName, m);
                }
                m.count += item.getCount();
                missesTotal += item.getCount();
            }
        }
        reportsTable.append("<tr><td>");
        boolean bl = select = reportName != null && reportName.trim().length() > 0;
        if (select) {
            reportsTable.append("<a href='HtmlAdaptor?").append("action=invokeOpByName&name=").append(this.getServiceName()).append("&methodName=generate&").append("argType=java.lang.String&arg0=").append("'>");
        }
        reportsTable.append("all transactions");
        if (select) {
            reportsTable.append("</a>");
        }
        reportsTable.append("</td><td>").append(txTotal).append("</td></tr></table>");
        for (Contention c : contention.values()) {
            contentionBuf.append("<tr><td>").append(c.tableName).append("</td><td>").append(c.total).append("</td><td>").append(c.maxTime).append("</td><td>").append(c.count).append("</td></tr>");
        }
        for (Eviction e : eviction.values()) {
            evictionBuf.append("<tr><td>").append(e.tableName).append("</td><td>").append(e.count).append("</td></tr>");
        }
        StringBuffer partitionBuf = new StringBuffer();
        partitionBuf.append("<table>");
        for (Hit h : hits.values()) {
            hitsBuf.append("<tr><td>").append(h.tableName).append("</td><td>").append(h.count).append("</td></tr>");
            if (h.partitions == null || h.partitions.length <= 0) continue;
            partitionBuf.append("<tr><td>");
            partitionBuf.append("<table><tr><th>Table: ").append(h.tableName).append("</th></tr>").append("<tr><th>Partition index</th><th>count</th><th>%</th></tr>");
            for (int pI = 0; pI < h.partitions.length; ++pI) {
                int hit = h.partitions[pI];
                partitionBuf.append("<tr><td>").append(pI).append("</td><td>").append(hit).append("</td><td>").append((int)(100.0 * ((double)hit / (double)h.maxHitPerPartition))).append("</td></tr>");
            }
            partitionBuf.append("</table>");
            partitionBuf.append("</td></tr>");
        }
        partitionBuf.append("</table>");
        for (Miss m : misses.values()) {
            missesBuf.append("<tr><td>").append(m.tableName).append("</td><td>").append(m.count).append("</td></tr>");
        }
        contentionBuf.append("<tr><td><font color='red'>total</font></td><td><font color='red'>").append(contentionTimeTotal).append("</font></td><td><font color='red'>").append(maxContentionTime).append("</font></td><td><font color='red'>").append(contentionTotal).append("</font></td></tr>").append("</table>");
        evictionBuf.append("<tr><td><font color='red'>total</font></td><td><font color='red'>").append(evictionTotal).append("</font></td></tr>").append("</table>");
        hitsBuf.append("<tr><td><font color='red'>total</font></td><td><font color='red'>").append(hitsTotal).append("</font></td></tr>").append("</table>");
        missesBuf.append("<tr><td><font color='red'>total</font></td><td><font color='red'>").append(missesTotal).append("</font></td></tr>").append("</table>");
        content.append("<table><tr valign='top'><td>").append(reportsTable).append("</td><td>").append(contentionBuf).append("</td><td>").append(evictionBuf).append("</td><td>").append(hitsBuf).append("</td><td>").append(missesBuf).append("</td></tr></table>");
        content.append(partitionBuf);
    }

    class Miss {
        public final String tableName;
        public int count;

        public Miss(String tableName) {
            this.tableName = tableName;
        }
    }

    class Hit {
        public final String tableName;
        public int count;
        private int[] partitions;
        private int maxHitPerPartition;

        public Hit(String tableName) {
            this.tableName = tableName;
        }

        public void partitionHit(int partitionIndex, int count) {
            if (this.partitions == null) {
                this.partitions = new int[partitionIndex + 1];
            } else if (this.partitions.length < partitionIndex + 1) {
                int[] tmp = this.partitions;
                this.partitions = new int[partitionIndex + 1];
                System.arraycopy(tmp, 0, this.partitions, 0, tmp.length);
            }
            int n = partitionIndex;
            this.partitions[n] = this.partitions[n] + count;
            this.count += count;
            if (this.maxHitPerPartition < this.partitions[partitionIndex]) {
                this.maxHitPerPartition = this.partitions[partitionIndex];
            }
        }
    }

    class Eviction {
        public final String tableName;
        public int count;

        public Eviction(String tableName) {
            this.tableName = tableName;
        }
    }

    class Contention {
        public final String tableName;
        public int total;
        public long maxTime;
        public int count;

        public Contention(String tableName) {
            this.tableName = tableName;
        }
    }
}

