/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor;

import java.util.ArrayList;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.monitor.JBossMonitorMBean;
import org.jboss.system.ServiceMBeanSupport;

public abstract class JBossMonitor
extends ServiceMBeanSupport
implements Runnable,
JBossMonitorMBean {
    protected Logger log;
    protected String monitorName;
    protected ObjectName observedObject;
    protected String attribute;
    protected boolean enabled;
    protected boolean alertSent = false;
    protected long period;
    protected ArrayList alertListeners = null;
    protected String thresholdString;
    protected Object triggeredAttributeValue;
    protected long triggerTime;

    protected void startService() throws Exception {
        super.startService();
        this.log = Logger.getLogger((String)this.monitorName);
        if (this.alertListeners != null) {
            for (int i = 0; i < this.alertListeners.size(); ++i) {
                ObjectName aname = (ObjectName)this.alertListeners.get(i);
                this.getServer().addNotificationListener(this.getServiceName(), aname, null, null);
            }
        }
        if (this.enabled) {
            this.startMonitorThread();
        }
    }

    protected void stopService() {
        this.enabled = false;
    }

    protected void startMonitorThread() {
        Thread t = new Thread((Runnable)this, "JBoss JMX Attribute Monitor " + this.monitorName);
        t.start();
    }

    protected abstract void testThreshold();

    public String getMonitorName() {
        return this.monitorName;
    }

    public void setMonitorName(String name) {
        this.monitorName = name;
    }

    public ObjectName getObservedObject() {
        return this.observedObject;
    }

    public void setObservedObject(ObjectName oname) {
        this.observedObject = oname;
    }

    public String getObservedAttribute() {
        return this.attribute;
    }

    public void setObservedAttribute(String attr) {
        this.attribute = attr;
    }

    public boolean alerted() {
        return this.alertSent;
    }

    public void clearAlert() {
        this.alertSent = false;
        this.triggeredAttributeValue = null;
        this.triggerTime = 0L;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean start) {
        if (start == this.enabled) {
            return;
        }
        this.enabled = start;
        if (start && this.getState() == 3) {
            this.startMonitorThread();
        }
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public ArrayList getAlertListeners() {
        return this.alertListeners;
    }

    public void setAlertListeners(ArrayList listeners) {
        if (this.alertListeners != null && this.getState() == 3) {
            int i;
            ArrayList copy = new ArrayList(listeners);
            for (i = 0; i < this.alertListeners.size(); ++i) {
                ObjectName oname = (ObjectName)this.alertListeners.get(i);
                int idx = copy.indexOf(oname);
                if (idx == -1) {
                    try {
                        this.getServer().removeNotificationListener(this.getServiceName(), oname);
                    }
                    catch (Exception ex) {
                        this.getLog().warn((Object)"failed to remove listener", (Throwable)ex);
                    }
                    continue;
                }
                copy.remove(idx);
            }
            for (i = 0; i < copy.size(); ++i) {
                ObjectName aname = (ObjectName)copy.get(i);
                try {
                    this.getServer().addNotificationListener(this.getServiceName(), aname, null, null);
                    continue;
                }
                catch (Exception ex) {
                    this.getLog().warn((Object)"failed to remove listener", (Throwable)ex);
                }
            }
        }
        this.alertListeners = listeners;
    }

    public Object getTriggeredAttributeValue() {
        return this.triggeredAttributeValue;
    }

    public long getTriggerTime() {
        return this.triggerTime;
    }

    public void run() {
        while (this.getState() == 3 || this.getState() == 2) {
            if (this.enabled) {
                try {
                    this.testThreshold();
                }
                catch (Exception ex) {
                    this.log.error((Object)(this.monitorName + " had error while monitoring"), (Throwable)ex);
                }
            }
            try {
                Thread.sleep(this.period);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public String getThreshold() {
        return this.thresholdString;
    }

    public void setThreshold(String val) {
        this.thresholdString = val;
    }
}

