/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor;

import java.util.ArrayList;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.monitor.SnapshotRecordingMonitorMBean;

public class SnapshotRecordingMonitor
implements Runnable,
SnapshotRecordingMonitorMBean,
MBeanRegistration {
    protected Logger log;
    protected String monitorName;
    protected ObjectName observedObject;
    protected String attribute;
    protected boolean recording;
    protected long period;
    protected ArrayList history;
    protected long startTime;
    protected long endTime;
    protected MBeanServer mbeanServer;

    public SnapshotRecordingMonitor() {
        this.log = Logger.getLogger((String)this.monitorName);
        this.history = new ArrayList(100);
    }

    protected void startMonitorThread() {
        Thread t = new Thread((Runnable)this, "JBoss JMX Attribute Snapshot " + this.monitorName);
        t.start();
    }

    public String getMonitorName() {
        return this.monitorName;
    }

    public void setMonitorName(String name) {
        this.monitorName = name;
    }

    public ObjectName getObservedObject() {
        return this.observedObject;
    }

    public void setObservedObject(ObjectName oname) {
        this.observedObject = oname;
    }

    public String getObservedAttribute() {
        return this.attribute;
    }

    public void setObservedAttribute(String attr) {
        this.attribute = attr;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void setRecording(boolean start) {
        if (start == this.recording) {
            return;
        }
        this.recording = start;
        if (start) {
            this.startMonitorThread();
        }
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public ArrayList getData() {
        return this.history;
    }

    public void clearData() {
        this.history.clear();
    }

    public void startSnapshot() {
        this.history.clear();
        this.setRecording(true);
    }

    public void endSnapshot() {
        this.recording = false;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean intr = false;
        try {
            this.startTime = System.currentTimeMillis();
            while (this.recording) {
                try {
                    Object value = this.mbeanServer.getAttribute(this.observedObject, this.attribute);
                    this.history.add(value);
                    this.endTime = System.currentTimeMillis();
                }
                catch (Exception ex) {
                    this.log.error((Object)(this.monitorName + " had error while monitoring"), (Throwable)ex);
                }
                if (!this.recording) continue;
                try {
                    Thread.sleep(this.period);
                }
                catch (InterruptedException ignored) {
                    intr = true;
                }
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName objectName) throws Exception {
        this.mbeanServer = server;
        return objectName;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }
}

