/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.trapd;

import java.net.InetAddress;
import org.jboss.logging.Logger;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpTrapHandler;
import org.opennms.protocols.snmp.SnmpTrapSession;
import org.opennms.protocols.snmp.SnmpVarBind;

public class TrapReceiver
implements SnmpTrapHandler {
    protected final Logger log;

    public TrapReceiver(Logger log) {
        this.log = log;
    }

    public void snmpReceivedTrap(SnmpTrapSession session, InetAddress agent, int port, SnmpOctetString community, SnmpPduPacket pdu) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("V2 Trap from ").append(agent.toString());
        sbuf.append(" on port ").append(port);
        sbuf.append("\nPDU command......... ").append(pdu.getCommand());
        sbuf.append("\nPDU Length.......... ").append(pdu.getLength());
        sbuf.append("\nCommunity string.... ").append(community.toString());
        if (pdu instanceof SnmpPduRequest) {
            SnmpPduRequest spdu = (SnmpPduRequest)pdu;
            sbuf.append("\nPDU Error Status.... ").append(spdu.getErrorStatus());
            sbuf.append("\nPDU Error Index..... ").append(spdu.getErrorIndex());
            sbuf.append("\n");
        }
        for (int i = 0; i < pdu.getLength(); ++i) {
            SnmpVarBind vb = pdu.getVarBindAt(i);
            sbuf.append("Varbind[").append(i).append("] := ");
            sbuf.append(vb.getName().toString()).append(" --> ");
            sbuf.append(vb.getValue().toString()).append("\n");
        }
        this.log.debug((Object)sbuf.toString());
    }

    public void snmpReceivedTrap(SnmpTrapSession session, InetAddress agent, int port, SnmpOctetString community, SnmpPduTrap pdu) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("V1 Trap from agent ").append(agent.toString());
        sbuf.append(" on port ").append(port);
        sbuf.append("\nIP Address......... ").append(pdu.getAgentAddress());
        sbuf.append("\nEnterprise Id...... ").append(pdu.getEnterprise());
        sbuf.append("\nGeneric ........... ").append(pdu.getGeneric());
        sbuf.append("\nSpecific .......... ").append(pdu.getSpecific());
        sbuf.append("\nTimeStamp ......... ").append(pdu.getTimeStamp());
        sbuf.append("\nLength............. ").append(pdu.getLength());
        sbuf.append("\nCommunity string... ").append(community.toString());
        sbuf.append("\n");
        for (int i = 0; i < pdu.getLength(); ++i) {
            SnmpVarBind vb = pdu.getVarBindAt(i);
            sbuf.append("Varbind[").append(i).append("] := ");
            sbuf.append(vb.getName().toString()).append(" --> ");
            sbuf.append(vb.getValue().toString()).append("\n");
        }
        this.log.debug((Object)sbuf.toString());
    }

    public void snmpTrapSessionError(SnmpTrapSession session, int error, Object ref) {
        StringBuffer sbuf = new StringBuffer();
        if (ref != null) {
            sbuf.append("Session error (").append(error).append(") reference: ");
            sbuf.append(ref.toString());
        } else {
            sbuf.append("Session error (").append(error).append(")");
        }
        try {
            if (error == -1) {
                session.raise();
            }
        }
        catch (Throwable e) {
            sbuf.append(" <").append(e).append(">");
        }
        this.log.error((Object)sbuf.toString());
    }
}

