/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.jdbc.DerbyDatabaseMBean;
import org.jboss.system.ServiceMBeanSupport;

public class DerbyDatabase
extends ServiceMBeanSupport
implements DerbyDatabaseMBean,
MBeanRegistration {
    private static final String DEFAULT_PASSWORD = "";
    private static final String DEFAULT_USER = "sa";
    private static final String JDBC_DRIVER_CLASS = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String JDBC_URL_PREFIX = "jdbc:derby:";
    private static final String DERBY_DATA_DIR = "derby";
    private static final String DEFAULT_DATABASE_NAME = "default";
    String name = "default";
    private String user = "sa";
    private String password = "";
    private Connection connection;

    public void setDatabase(String name) {
        if (name == null) {
            name = DEFAULT_DATABASE_NAME;
        }
        this.name = name;
    }

    public String getDatabase() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        if (password == null) {
            password = DEFAULT_PASSWORD;
        }
        this.password = password;
    }

    public void setUser(String user) {
        if (user == null) {
            user = DEFAULT_USER;
        }
        this.user = user;
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? OBJECT_NAME : name;
    }

    protected void startService() throws Exception {
        String dbURL = JDBC_URL_PREFIX + System.getProperty("jboss.server.data.dir") + '/' + DERBY_DATA_DIR + '/' + this.name + ";create=true";
        this.log.info((Object)("starting derby " + dbURL));
        this.connection = this.getConnection(dbURL);
    }

    protected void stopService() throws Exception {
        try {
            this.getConnection("jdbc:derby:;shutdown=true");
            this.log.error((Object)"According to the docs, should have caught an exception!");
        }
        catch (SQLException e) {
            this.log.info((Object)"Derby shutdown successfully.", (Throwable)e);
        }
        this.connection = null;
    }

    private synchronized Connection getConnection(String dbURL) throws Exception {
        if (this.connection == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class.forName(JDBC_DRIVER_CLASS, true, cl).newInstance();
            this.connection = DriverManager.getConnection(dbURL, this.user, this.password);
        }
        return this.connection;
    }
}

