/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector.invoker;

import java.security.Principal;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import org.jboss.jmx.connector.invoker.SecurityActions;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.server.Invocation;
import org.jboss.security.SecurityContext;
import org.jboss.security.SubjectSecurityManager;

public final class AuthenticationInterceptor
extends AbstractInterceptor {
    private SubjectSecurityManager securityMgr;
    private String securityDomain;
    private boolean initialized = false;

    public void setSecurityDomain(String securityDomain) throws Exception {
        this.securityDomain = securityDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        String opName;
        String type = invocation.getType();
        Subject subject = null;
        if (!this.initialized) {
            this.initialize();
        }
        if (type == "invoke" && this.securityMgr != null && (opName = invocation.getName()).equals("invoke")) {
            Object credential;
            Object[] args = invocation.getArgs();
            org.jboss.invocation.Invocation inv = (org.jboss.invocation.Invocation)args[0];
            Principal caller = inv.getPrincipal();
            boolean isValid = this.securityMgr.isValid(caller, credential = inv.getCredential(), subject = new Subject());
            if (!isValid) {
                String msg = "Failed to authenticate principal=" + caller + ", securityDomain=" + this.securityMgr.getSecurityDomain();
                throw new SecurityException(msg);
            }
            String securityDomain = "other";
            if (this.securityMgr != null) {
                securityDomain = this.securityMgr.getSecurityDomain();
            }
            SecurityContext sc = SecurityActions.createSecurityContext(securityDomain);
            SecurityActions.setSecurityContext(sc);
            SecurityActions.pushSubjectContext(caller, credential, subject);
        }
        try {
            AbstractInterceptor i = invocation.nextInterceptor();
            Object object = i.invoke(invocation);
            return object;
        }
        finally {
            if (subject != null) {
                SecurityActions.popSubjectContext();
            }
        }
    }

    private void initialize() {
        try {
            InitialContext ctx = new InitialContext();
            this.securityMgr = (SubjectSecurityManager)ctx.lookup(this.securityDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.securityMgr == null) {
            this.log.warn((Object)("Unable to locate security domain " + this.securityDomain + ". The AuthenticationInterceptor will have no effect"));
        }
        this.initialized = true;
    }
}

