/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.http.servlet;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.invocation.MarshalledValue;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;

public class NamingFactoryServlet
extends HttpServlet {
    private static String RESPONSE_CONTENT_TYPE = "application/x-java-serialized-object; class=org.jboss.invocation.MarshalledValue";
    private Logger log;
    private Object namingProxy;
    private ObjectName namingProxyMBean;
    private String proxyAttribute;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String category = ((Object)((Object)this)).getClass().getName() + '.' + config.getServletName();
        this.log = Logger.getLogger((String)category);
        String name = config.getInitParameter("namingProxyMBean");
        if (name == null) {
            throw new ServletException("An namingProxyMBean must be specified");
        }
        this.proxyAttribute = config.getInitParameter("proxyAttribute");
        if (this.proxyAttribute == null) {
            this.proxyAttribute = "Proxy";
        }
        try {
            this.namingProxyMBean = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new ServletException("Failed to create object name: " + name, (Throwable)e);
        }
    }

    public void destroy() {
    }

    public String getServletInfo() {
        return "A factory servlet for Naming proxies";
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)"processRequest");
        }
        this.lookupNamingProxy();
        try {
            response.setContentType(RESPONSE_CONTENT_TYPE);
            MarshalledValue mv = new MarshalledValue(this.namingProxy);
            if (trace) {
                this.log.trace((Object)("Serialized Naming proxy, size=" + mv.size()));
            }
            ServletOutputStream sos = response.getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)sos);
            oos.writeObject(mv);
            oos.flush();
            oos.close();
        }
        catch (Throwable t) {
            this.log.debug((Object)"Invoke failed", t);
            response.resetBuffer();
            MarshalledValue mv = new MarshalledValue((Object)t);
            ServletOutputStream sos = response.getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)sos);
            oos.writeObject(mv);
            oos.close();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    private synchronized void lookupNamingProxy() throws ServletException {
        if (this.namingProxy != null) {
            return;
        }
        MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
        try {
            this.namingProxy = mbeanServer.getAttribute(this.namingProxyMBean, this.proxyAttribute);
        }
        catch (Exception e) {
            String msg = "Failed to obtain proxy from: " + this.namingProxyMBean + " via attribute:" + this.proxyAttribute;
            this.log.debug((Object)msg, (Throwable)e);
            throw new ServletException(msg, (Throwable)e);
        }
    }
}

