/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.examples.configuration;

import java.io.Serializable;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.jmx.examples.configuration.MBeanConfiguratorSupportMBean;
import org.jboss.logging.Logger;
import org.jboss.services.binding.ServiceBindingManager;
import org.jboss.system.ServiceMBeanSupport;

public abstract class MBeanConfiguratorSupport
extends ServiceMBeanSupport
implements MBeanConfiguratorSupportMBean,
NotificationListener {
    private static final Logger log = Logger.getLogger((String)MBeanConfiguratorSupport.class.getName());
    private ServiceBindingManager serviceBindingManager;

    public String getName() {
        return "MBeanConfiguratorSupport";
    }

    public void startService() {
        try {
            log.debug((Object)"Starting MBeanConfiguratorSupport service.");
            ObjectName mbeanserver = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            RegistrationNotificationFilter mbeanServerNotificationFilter = new RegistrationNotificationFilter();
            this.getServer().addNotificationListener(mbeanserver, this, (NotificationFilter)mbeanServerNotificationFilter, null);
        }
        catch (Exception e) {
            log.error((Object)"Could not start MBeanConfiguratorSupport service.", (Throwable)e);
        }
    }

    public ServiceBindingManager getServiceBindingManager() {
        return this.serviceBindingManager;
    }

    public void setServiceBindingManager(ServiceBindingManager serviceBindingManager) {
        this.serviceBindingManager = serviceBindingManager;
    }

    public abstract void mbeanRegistered(ObjectName var1) throws Exception;

    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification && notification.getType().equals("JMX.mbean.registered")) {
            MBeanServerNotification serverNotification = (MBeanServerNotification)notification;
            try {
                this.mbeanRegistered(serverNotification.getMBeanName());
            }
            catch (Exception e) {
                log.error((Object)("Error configuring mbean " + serverNotification.getMBeanName()), (Throwable)e);
            }
        }
    }

    public class RegistrationNotificationFilter
    implements NotificationFilter,
    Serializable {
        public boolean isNotificationEnabled(Notification notification) {
            boolean processNotification = false;
            if (notification instanceof MBeanServerNotification && notification.getType().equals("JMX.mbean.registered")) {
                processNotification = true;
            }
            return processNotification;
        }
    }
}

