/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.Servlet;
import org.dom4j.Document;
import org.dom4j.Element;
import org.jboss.logging.Logger;
import org.jboss.wsf.container.jboss50.RewriteResults;
import org.jboss.wsf.container.jboss50.WebAppDesciptorModifier;
import org.jboss.wsf.spi.deployment.Deployment;

public class DefaultWebAppDesciptorModifierImpl
implements WebAppDesciptorModifier {
    private static Logger log = Logger.getLogger(DefaultWebAppDesciptorModifierImpl.class);

    public RewriteResults modifyDescriptor(Deployment dep, Document webXml) throws ClassNotFoundException {
        String listenerClass;
        RewriteResults results = new RewriteResults();
        Element root = webXml.getRootElement();
        String servletClass = (String)dep.getProperty("org.jboss.ws.webapp.ServletClass");
        if (servletClass == null) {
            throw new IllegalStateException("Cannot obtain context property: org.jboss.ws.webapp.ServletClass");
        }
        Map contextParams = (Map)dep.getProperty("org.jboss.ws.webapp.ContextParameterMap");
        if (contextParams != null) {
            for (Map.Entry entry : contextParams.entrySet()) {
                Element contextParamTmp = root.addElement("context-param-tmp");
                Element contextParam = (Element)contextParamTmp.clone();
                contextParam.setName("context-param");
                contextParam.addElement("param-name").addText((String)entry.getKey());
                contextParam.addElement("param-value").addText((String)entry.getValue());
                root.content().add(0, contextParam);
                root.remove(contextParamTmp);
            }
        }
        if ((listenerClass = (String)dep.getProperty("org.jboss.ws.webapp.ServletContextListener")) != null) {
            Element listener = root.addElement("listener");
            listener.addElement("listener-class").setText(listenerClass);
        }
        Iterator it = root.elementIterator("servlet");
        while (it.hasNext()) {
            Element servlet = (Element)it.next();
            String linkName = servlet.element("servlet-name").getTextTrim();
            Element classElement = servlet.element("servlet-class");
            if (classElement == null) continue;
            String orgServletClassName = classElement.getTextTrim();
            Class<?> orgServletClass = null;
            try {
                ClassLoader loader = dep.getInitialClassLoader();
                orgServletClass = loader.loadClass(orgServletClassName);
            }
            catch (ClassNotFoundException ex) {
                log.warn((Object)("Cannot load servlet class: " + orgServletClassName));
            }
            String targetBeanName = null;
            if (this.isAlreadyModified(servlet)) {
                Iterator itParam = servlet.elementIterator("init-param");
                while (itParam.hasNext()) {
                    Element elParam = (Element)itParam.next();
                    String paramName = elParam.element("param-name").getTextTrim();
                    String paramValue = elParam.element("param-value").getTextTrim();
                    if (!"jboss.ws.endpoint".equals(paramName)) continue;
                    targetBeanName = paramValue;
                }
            } else {
                if (orgServletClass != null && Servlet.class.isAssignableFrom(orgServletClass)) {
                    log.info((Object)("Ignore servlet: " + orgServletClassName));
                    continue;
                }
                if (orgServletClassName.endsWith("Servlet")) {
                    log.info((Object)("Ignore <servlet-class> that ends with 'Servlet': " + orgServletClassName));
                    continue;
                }
                classElement.setText(servletClass);
                if (!orgServletClassName.equals(servletClass)) {
                    targetBeanName = orgServletClassName;
                    Element paramElement = servlet.addElement("init-param");
                    paramElement.addElement("param-name").addText("jboss.ws.endpoint");
                    paramElement.addElement("param-value").addText(targetBeanName);
                }
            }
            if (targetBeanName == null) {
                throw new IllegalStateException("Cannot obtain service endpoint bean for: " + linkName);
            }
            results.sepTargetMap.put(linkName, targetBeanName);
        }
        return results;
    }

    private boolean isAlreadyModified(Element servlet) {
        Iterator it = servlet.elementIterator("init-param");
        while (it.hasNext()) {
            Element elParam = (Element)it.next();
            String paramName = elParam.element("param-name").getTextTrim();
            if (!"jboss.ws.endpoint".equals(paramName)) continue;
            return true;
        }
        return false;
    }
}

