/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.deployer;

import java.io.InputStream;
import java.net.URL;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.serviceref.VirtualFileAdaptor;
import org.jboss.virtual.VirtualFile;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.container.jboss50.deployer.AbstractDeployerHook;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;
import org.jboss.wsf.spi.metadata.webservices.WebservicesFactory;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.w3c.dom.Element;

public abstract class ArchiveDeployerHook
extends AbstractDeployerHook {
    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (!this.ignoreDeployment(unit) && this.isWebServiceDeployment(unit)) {
            this.log.debug((Object)("deploy: " + unit.getName()));
            Deployment dep = this.getDeployment(unit);
            if (dep == null) {
                dep = this.createDeployment(unit);
                dep.addAttachment(DeploymentUnit.class, (Object)unit);
            }
            if (Deployment.DeploymentState.UNDEFINED == dep.getState()) {
                this.getWsfRuntime().create(dep);
                unit.addAttachment(Deployment.class, (Object)dep);
            } else {
                throw new IllegalArgumentException("Cannot process Deployment in state " + dep.getState() + ": " + dep);
            }
        }
    }

    public void undeploy(DeploymentUnit unit) {
        if (this.ignoreDeployment(unit)) {
            return;
        }
        Deployment dep = this.getDeployment(unit);
        if (dep != null) {
            this.log.debug((Object)("undeploy: " + unit.getName()));
            this.getWsfRuntime().stop(dep);
            this.getWsfRuntime().destroy(dep);
        }
    }

    public abstract boolean isWebServiceDeployment(DeploymentUnit var1);

    public abstract Deployment createDeployment(DeploymentUnit var1);

    public Deployment getDeployment(DeploymentUnit unit) {
        Deployment dep = (Deployment)unit.getAttachment(Deployment.class);
        return dep != null && dep.getType() == this.getDeploymentType() ? dep : null;
    }

    protected WebservicesMetaData getWebservicesMetaData(DeploymentUnit unit) {
        WebservicesMetaData wsMetaData = (WebservicesMetaData)unit.getAttachment(WebservicesMetaData.class);
        UnifiedVirtualFile vfWebservices = this.getWebservicesFile(unit);
        if (wsMetaData == null && vfWebservices != null) {
            try {
                URL wsURL = vfWebservices.toURL();
                Element root = DOMUtils.parse((InputStream)wsURL.openStream());
                String namespaceURI = root.getNamespaceURI();
                if (namespaceURI.equals("http://java.sun.com/xml/ns/j2ee")) {
                    Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                    WebservicesFactory factory = new WebservicesFactory(wsURL);
                    wsMetaData = (WebservicesMetaData)unmarshaller.unmarshal(wsURL.openStream(), (ObjectModelFactory)factory, null);
                    unit.addAttachment(WebservicesMetaData.class, (Object)wsMetaData);
                }
            }
            catch (Exception ex) {
                throw new WSFDeploymentException((Throwable)ex);
            }
        }
        return wsMetaData;
    }

    private UnifiedVirtualFile getWebservicesFile(DeploymentUnit unit) {
        VirtualFileAdaptor wsFile = null;
        if (unit instanceof VFSDeploymentUnit) {
            VirtualFile vf = ((VFSDeploymentUnit)unit).getMetaDataFile("webservices.xml");
            wsFile = vf != null ? new VirtualFileAdaptor(vf) : null;
        }
        return wsFile;
    }
}

