/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.invocation;

import java.lang.reflect.Method;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.ws.WebServiceException;
import org.jboss.ejb3.EJBContainer;
import org.jboss.wsf.common.invocation.AbstractInvocationHandler;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.integration.InvocationContextCallback;
import org.jboss.wsf.spi.invocation.integration.ServiceEndpointContainer;
import org.jboss.wsf.spi.ioc.IoCContainerProxy;
import org.jboss.wsf.spi.ioc.IoCContainerProxyFactory;

final class InvocationHandlerEJB3
extends AbstractInvocationHandler {
    private static final String EJB3_JNDI_PREFIX = "java:env/";
    private final IoCContainerProxy iocContainer;
    private String containerName;
    private ServiceEndpointContainer serviceEndpointContainer;

    InvocationHandlerEJB3() {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        IoCContainerProxyFactory iocContainerFactory = (IoCContainerProxyFactory)spiProvider.getSPI(IoCContainerProxyFactory.class);
        this.iocContainer = iocContainerFactory.getContainer();
    }

    public void init(Endpoint endpoint) {
        this.containerName = (String)endpoint.getProperty("org.jboss.wsf.spi.invocation.ContainerName");
        if (this.containerName == null) {
            throw new IllegalArgumentException("Container name cannot be null");
        }
    }

    private synchronized ServiceEndpointContainer getEjb3Container() {
        boolean ejb3ContainerNotInitialized;
        boolean bl = ejb3ContainerNotInitialized = this.serviceEndpointContainer == null;
        if (ejb3ContainerNotInitialized) {
            this.serviceEndpointContainer = (ServiceEndpointContainer)this.iocContainer.getBean(this.containerName, ServiceEndpointContainer.class);
            if (this.serviceEndpointContainer == null) {
                throw new WebServiceException("Cannot find service endpoint target: " + this.containerName);
            }
        }
        return this.serviceEndpointContainer;
    }

    public void invoke(Endpoint endpoint, Invocation wsInvocation) throws Exception {
        try {
            ServiceEndpointContainer ejbContainer = this.getEjb3Container();
            EJB3InvocationContextCallback invocationCallback = new EJB3InvocationContextCallback(wsInvocation);
            Class implClass = ejbContainer.getServiceImplementationClass();
            Method seiMethod = wsInvocation.getJavaMethod();
            Method implMethod = this.getImplMethod(implClass, seiMethod);
            Object[] args = wsInvocation.getArgs();
            Object retObj = ejbContainer.invokeEndpoint(implMethod, args, (InvocationContextCallback)invocationCallback);
            wsInvocation.setReturnValue(retObj);
        }
        catch (Throwable t) {
            this.log.error((Object)("Method invocation failed with exception: " + t.getMessage()), t);
            this.handleInvocationException(t);
        }
    }

    public Context getJNDIContext(Endpoint ep) throws NamingException {
        EJBContainer ejb3Container = (EJBContainer)this.getEjb3Container();
        return (Context)ejb3Container.getEnc().lookup(EJB3_JNDI_PREFIX);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EJB3InvocationContextCallback
    implements InvocationContextCallback {
        private Invocation wsInvocation;

        public EJB3InvocationContextCallback(Invocation wsInvocation) {
            this.wsInvocation = wsInvocation;
        }

        public <T> T get(Class<T> attachmentType) {
            return (T)this.wsInvocation.getInvocationContext().getAttachment(attachmentType);
        }
    }
}

