/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossas.servermanager;

import java.io.File;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.jbossas.servermanager.Argument;
import org.jboss.jbossas.servermanager.Property;
import org.jboss.jbossas.servermanager.ServerManager;

public class Server {
    public static final String JBOSS_SERVER_CONFIG_DIR_NAME = "server";
    public static final String JBOSS_SERVER_DEPLOY_DIR_NAME = "deploy";
    private String name;
    private String config;
    private String username;
    private String password;
    private List<Argument> arguments = new ArrayList<Argument>();
    private Process process;
    private List<Argument> jvmArguments = new ArrayList<Argument>();
    private List<Property> sysProperties = new ArrayList<Property>();
    private Integer httpPort = new Integer(8080);
    private Integer rmiPort = new Integer(1099);
    private String host = "localhost";
    private ServerManager manager;
    private PrintWriter outWriter;
    private PrintWriter errorWriter;
    private boolean hasWebServer = true;
    private Context namingContext;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected void setManager(ServerManager manager) {
        this.manager = manager;
    }

    public void addArg(Argument arg) {
        this.arguments.add(arg);
    }

    public String getArgs() {
        StringBuffer args = new StringBuffer();
        for (Argument argument : this.arguments) {
            args.append(argument.getValue() + " ");
        }
        return args.toString();
    }

    public void addJvmArg(Argument arg) {
        this.jvmArguments.add(arg);
    }

    public String getJvmArgs() {
        StringBuffer args = new StringBuffer();
        for (Argument argument : this.jvmArguments) {
            args.append(argument.getValue() + " ");
        }
        return args.toString();
    }

    public void addSysProperty(Property property) {
        this.sysProperties.add(property);
    }

    public String getSysProperty(String key) {
        for (Property property : this.sysProperties) {
            if (!key.equals(property.getKey())) continue;
            return property.getValue();
        }
        return null;
    }

    public String getSysProperties() {
        StringBuffer args = new StringBuffer();
        for (Property property : this.sysProperties) {
            args.append("-D" + property.getKey() + "=" + property.getValue() + " ");
        }
        return args.toString();
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public boolean isRunning() {
        if (this.isStopped()) {
            return false;
        }
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public boolean isStopped() {
        return this.process == null;
    }

    public Process getProcess() {
        return this.process;
    }

    public URL getHttpUrl() throws MalformedURLException {
        return new URL("http://" + this.host + ":" + this.httpPort);
    }

    public String getRmiUrl() {
        return "jnp://" + this.host + ":" + this.rmiPort;
    }

    public String getConfig() {
        if (this.config != null) {
            return this.config;
        }
        return this.name;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
    }

    public void setRmiPort(Integer rmiPort) {
        this.rmiPort = rmiPort;
    }

    public Integer getRmiPort() {
        return this.rmiPort;
    }

    public File getErrorLog() {
        return new File(this.getLogDir(), "error.log");
    }

    public File getOutputLog() {
        return new File(this.getLogDir(), "output.log");
    }

    private File getLogDir() {
        return new File(this.getConfDir(), "log");
    }

    private File getConfDir() {
        return new File(this.manager.getJBossHome(), "server/" + this.getConfig());
    }

    public void setOutWriter(PrintWriter outlog) {
        this.outWriter = outlog;
    }

    public PrintWriter getOutWriter() {
        return this.outWriter;
    }

    public PrintWriter getErrorWriter() {
        return this.errorWriter;
    }

    public void setErrorWriter(PrintWriter errorlog) {
        this.errorWriter = errorlog;
    }

    public boolean hasWebServer() {
        return this.hasWebServer;
    }

    public void setHasWebServer(boolean hasWebServer) {
        this.hasWebServer = hasWebServer;
    }

    public Context getNamingContext() throws NamingException {
        if (this.namingContext == null) {
            Properties properties = new Properties();
            properties.setProperty("java.naming.factory.initial", "org.jboss.naming.NamingContextFactory");
            properties.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            properties.setProperty("java.naming.provider.url", "jnp://" + this.getHost() + ':' + this.getRmiPort());
            this.setNamingContext(new InitialContext(properties));
        }
        return this.namingContext;
    }

    public void setNamingContext(Context namingContext) {
        this.namingContext = namingContext;
    }
}

