/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossas.servermanager;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jbossas.servermanager.Argument;
import org.jboss.jbossas.servermanager.Property;
import org.jboss.jbossas.servermanager.ServerManager;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;

public class Server {
    private static final Log log = LogFactory.getLog(Server.class);
    public static final String JBOSS_SERVER_CONFIG_DIR_NAME = "server";
    public static final String JBOSS_SERVER_DEPLOY_DIR_NAME = "deploy";
    private String name;
    private String config;
    private String username = null;
    private String password = null;
    private List<Argument> arguments = new ArrayList<Argument>();
    private Process process;
    private List<Argument> jvmArguments = new ArrayList<Argument>();
    private List<Property> sysProperties = new ArrayList<Property>();
    private Integer httpPort = new Integer(8080);
    private Integer rmiPort = new Integer(1099);
    private String host = "localhost";
    private ServerManager manager;
    private PrintWriter outWriter;
    private PrintWriter errorWriter;
    private boolean hasWebServer = true;
    private Context namingContext;
    public static final String DEPLOYER_NAME = "jboss.system:service=MainDeployer";
    private MBeanServerConnection serverConnection;
    private String serverUrl = null;
    private String initialContextFactoryClassName = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected void setManager(ServerManager manager) {
        this.manager = manager;
    }

    public void addArg(Argument arg) {
        this.arguments.add(arg);
    }

    public String getArgs() {
        StringBuffer args = new StringBuffer();
        for (Argument argument : this.arguments) {
            args.append(argument.getValue() + " ");
        }
        return args.toString();
    }

    public void addJvmArg(Argument arg) {
        this.jvmArguments.add(arg);
    }

    public String getJvmArgs() {
        StringBuffer args = new StringBuffer();
        for (Argument argument : this.jvmArguments) {
            args.append(argument.getValue() + " ");
        }
        return args.toString();
    }

    public void addSysProperty(Property property) {
        this.sysProperties.add(property);
    }

    public String getSysProperty(String key) {
        for (Property property : this.sysProperties) {
            if (!key.equals(property.getKey())) continue;
            return property.getValue();
        }
        return null;
    }

    public String getSysProperties() {
        StringBuffer args = new StringBuffer();
        for (Property property : this.sysProperties) {
            args.append("-D" + property.getKey() + "=" + property.getValue() + " ");
        }
        return args.toString();
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public boolean isRunning() {
        if (this.isStopped()) {
            return false;
        }
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public boolean isStopped() {
        return this.process == null;
    }

    public Process getProcess() {
        return this.process;
    }

    public URL getHttpUrl() throws MalformedURLException {
        return new URL("http://" + this.host + ":" + this.httpPort);
    }

    public String getRmiUrl() {
        return "jnp://" + this.host + ":" + this.rmiPort;
    }

    public String getConfig() {
        if (this.config != null) {
            return this.config;
        }
        return this.name;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
    }

    public void setRmiPort(Integer rmiPort) {
        this.rmiPort = rmiPort;
    }

    public Integer getRmiPort() {
        return this.rmiPort;
    }

    public File getErrorLog() {
        return new File(this.getLogDir(), "error.log");
    }

    public File getOutputLog() {
        return new File(this.getLogDir(), "output.log");
    }

    public File getDumpFile() {
        return new File(this.getLogDir(), "threadDump.log");
    }

    public File getLogDir() {
        return new File(this.getConfDir(), "log");
    }

    protected File getConfDir() {
        return new File(this.manager.getJBossHome(), "server/" + this.getConfig());
    }

    public void setOutWriter(PrintWriter outlog) {
        this.outWriter = outlog;
    }

    public PrintWriter getOutWriter() {
        return this.outWriter;
    }

    public PrintWriter getErrorWriter() {
        return this.errorWriter;
    }

    public void setErrorWriter(PrintWriter errorlog) {
        this.errorWriter = errorlog;
    }

    public boolean hasWebServer() {
        return this.hasWebServer;
    }

    public void setHasWebServer(boolean hasWebServer) {
        this.hasWebServer = hasWebServer;
    }

    public Context getNamingContext() throws NamingException {
        if (this.namingContext == null) {
            Properties properties = new Properties();
            properties.setProperty("java.naming.factory.initial", this.getInitialContextFactoryClassName());
            properties.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            properties.setProperty("java.naming.provider.url", this.getServerUrl());
            properties.setProperty("j2ee.clientName", "JBoss Server Manager");
            properties.setProperty("jnp.disableDiscovery", "true");
            if (this.username != null) {
                SecurityAssociation.setPrincipal((Principal)new SimplePrincipal(this.username));
                SecurityAssociation.setCredential((Object)this.password);
            }
            this.setNamingContext(new InitialContext(properties));
        }
        return this.namingContext;
    }

    public void setNamingContext(Context namingContext) {
        this.namingContext = namingContext;
    }

    public MBeanServerConnection getServerConnection() throws NamingException {
        String adapterName = "jmx/rmi/RMIAdaptor";
        if (this.serverConnection == null) {
            Object obj = this.getNamingContext().lookup(adapterName);
            if (obj == null) {
                throw new NameNotFoundException("Object " + adapterName + " not found.");
            }
            this.setServerConnection((MBeanServerConnection)obj);
        }
        return this.serverConnection;
    }

    public void setServerConnection(MBeanServerConnection serverConnection) {
        this.serverConnection = serverConnection;
    }

    public String listThreadDump() throws NamingException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        ObjectName serverInfoName;
        try {
            serverInfoName = new ObjectName("jboss.system", "type", "ServerInfo");
        }
        catch (MalformedObjectNameException mone) {
            throw new RuntimeException("Bad object name, something is totally broken", mone);
        }
        return (String)this.getServerConnection().invoke(serverInfoName, "listThreadDump", null, null);
    }

    public void doShutdown() throws NamingException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        ObjectName serverObjectName;
        try {
            serverObjectName = new ObjectName("jboss.system", "type", "Server");
        }
        catch (MalformedObjectNameException mone) {
            throw new RuntimeException("Bad object name, something is totally broken", mone);
        }
        this.getServerConnection().invoke(serverObjectName, "shutdown", null, null);
        try {
            this.getNamingContext().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setNamingContext(null);
        this.setServerConnection(null);
    }

    public String getServerUrl() {
        if (null == this.serverUrl) {
            return this.getRmiUrl();
        }
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getInitialContextFactoryClassName() {
        if (this.initialContextFactoryClassName != null) {
            return this.initialContextFactoryClassName;
        }
        if (this.getServerUrl().startsWith("http")) {
            return "org.jboss.naming.HttpNamingContextFactory";
        }
        return "org.jboss.naming.NamingContextFactory";
    }

    public void setInitialContextFactoryClassName(String initialContextFactoryClassName) {
        this.initialContextFactoryClassName = initialContextFactoryClassName;
    }

    ObjectName getDeployerName() throws MalformedObjectNameException {
        return new ObjectName(DEPLOYER_NAME);
    }

    public void deploy(File file) throws Exception {
        if (Boolean.getBoolean("jbosstest.nodeploy")) {
            log.debug((Object)("Skipping deployment of: " + this.name));
            return;
        }
        URL deployURL = file.toURL();
        log.debug((Object)("Deploying " + this.name + ", url=" + deployURL));
        this.invoke(this.getDeployerName(), JBOSS_SERVER_DEPLOY_DIR_NAME, new Object[]{deployURL}, new String[]{"java.net.URL"});
    }

    public void redeploy(File file) throws Exception {
        if (Boolean.getBoolean("jbosstest.nodeploy")) {
            log.debug((Object)("Skipping redeployment of: " + this.name));
            return;
        }
        URL deployURL = file.toURL();
        log.debug((Object)("Deploying " + this.name + ", url=" + deployURL));
        this.invoke(this.getDeployerName(), "redeploy", new Object[]{deployURL}, new String[]{"java.net.URL"});
    }

    public void undeploy(File file) throws Exception {
        if (Boolean.getBoolean("jbosstest.nodeploy")) {
            return;
        }
        URL deployURL = file.toURL();
        log.debug((Object)("Undeploying " + this.name + ", url=" + deployURL));
        Object[] args = new Object[]{deployURL};
        String[] sig = new String[]{"java.net.URL"};
        this.invoke(this.getDeployerName(), "undeploy", args, sig);
    }

    public Object invoke(ObjectName name, String method, Object[] args, String[] sig) throws Exception {
        return this.invoke(this.getServerConnection(), name, method, args, sig);
    }

    public Object invoke(MBeanServerConnection server, ObjectName name, String method, Object[] args, String[] sig) throws Exception {
        try {
            log.debug((Object)("Invoking " + name.getCanonicalName() + " method=" + method));
            if (args != null) {
                log.debug((Object)("args=" + Arrays.asList(args)));
            }
            return server.invoke(name, method, args, sig);
        }
        catch (MBeanException e) {
            log.error((Object)"MbeanException", (Throwable)e.getTargetException());
            throw e.getTargetException();
        }
        catch (ReflectionException e) {
            log.error((Object)"ReflectionException", (Throwable)e.getTargetException());
            throw e.getTargetException();
        }
        catch (RuntimeOperationsException e) {
            log.error((Object)"RuntimeOperationsException", (Throwable)e.getTargetException());
            throw e.getTargetException();
        }
        catch (RuntimeMBeanException e) {
            log.error((Object)"RuntimeMbeanException", (Throwable)e.getTargetException());
            throw e.getTargetException();
        }
        catch (RuntimeErrorException e) {
            log.error((Object)"RuntimeErrorException", (Throwable)e.getTargetError());
            throw e.getTargetError();
        }
    }
}

