/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossas.servermanager;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sun.tools.attach.HotSpotVirtualMachine;

public class JStackLikeDump {
    private static String killSequence = "kill -3 [pid]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getThreadDump(String pid) throws Exception {
        boolean makeDumpByKill = true;
        StringBuffer threadDump = new StringBuffer();
        VirtualMachine vm = null;
        InputStream in = null;
        try {
            int n;
            vm = VirtualMachine.attach(pid);
            in = ((HotSpotVirtualMachine)vm).remoteDataDump("-l");
            byte[] b = new byte[256];
            do {
                if ((n = in.read(b)) <= 0) continue;
                String s = new String(b, 0, n, "UTF-8");
                threadDump.append(s);
            } while (n > 0);
            makeDumpByKill = false;
        }
        catch (AttachNotSupportedException e) {
            System.err.println("The server process " + pid + " is not responding: " + e.getMessage());
            if (JStackLikeDump.loadSAClass() != null) {
                System.err.println("trying to use Oracle's SA JStack tool instead");
                System.err.println("Check the standard output for thread dump instead of the log file.");
                JStackLikeDump.runJStackTool(pid);
                makeDumpByKill = false;
            }
        }
        catch (Exception e) {
            System.err.println("Cannot attach to VM: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ignore) {}
            }
            if (vm != null) {
                try {
                    vm.detach();
                }
                catch (Exception ignore) {}
            }
        }
        if (makeDumpByKill) {
            System.err.println("trying to use " + killSequence + " instead (UNIX specific way)");
            threadDump.append(JStackLikeDump.dumpWithKill(pid));
        }
        return threadDump.toString();
    }

    private static void runJStackTool(String pid) throws Exception {
        Class cl = JStackLikeDump.loadSAClass();
        if (cl == null) {
            return;
        }
        String[] params = new String[]{"-m", "-l", pid};
        Class[] argTypes = new Class[]{String[].class};
        Method m = cl.getDeclaredMethod("main", argTypes);
        Object[] invokeArgs = new Object[]{params};
        m.invoke(null, invokeArgs);
    }

    private static Class loadSAClass() {
        try {
            return Class.forName("sun.jvm.hotspot.tools.JStack");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Set<String> getJVMPids(String mainClass) {
        HashSet<String> jvmPids = new HashSet<String>();
        List<VirtualMachineDescriptor> vms = VirtualMachine.list();
        for (VirtualMachineDescriptor vm : vms) {
            if (vm.displayName().indexOf(mainClass) < 0) continue;
            jvmPids.add(vm.id());
        }
        return jvmPids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String dumpWithKill(String pid) {
        StringBuffer killOutput = new StringBuffer();
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("windows") > -1) {
            return killOutput.append("Kill command unsupported on this platform").toString();
        }
        String killCommand = killSequence.replace("[pid]", pid);
        String nl = System.getProperty("line.separator");
        killOutput.append("calling " + killCommand + " ...").append(nl);
        Process p = null;
        InputStream out = null;
        try {
            String result;
            p = Runtime.getRuntime().exec(killCommand);
            p.waitFor();
            int rc = p.exitValue();
            if (rc != 0) {
                killOutput.append("Kill sequence failed").append(nl);
            }
            out = p.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(out));
            do {
                if ((result = in.readLine()) == null) continue;
                killOutput.append(result).append(nl);
            } while (result != null);
        }
        catch (Exception e) {
            killOutput.append("Kill sequence failed: ").append(e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignore) {}
            }
            if (p != null) {
                p.destroy();
            }
        }
        return killOutput.toString();
    }

    public static void main(String[] argv) {
        System.out.println("JStackLikeDump.loadSAClass()=" + JStackLikeDump.loadSAClass());
        Set<String> jvmPIDs = JStackLikeDump.getJVMPids("org.jboss.Main");
        System.out.println("jvmPIDs = " + jvmPIDs);
        for (String pid : jvmPIDs) {
            try {
                System.out.println("===== Thread dump of " + pid + " PID");
                System.out.println(JStackLikeDump.getThreadDump(pid));
                System.out.println("=====");
            }
            catch (Exception e) {
                System.err.println("Unable to get server thread dump of " + pid + " PID!");
                e.printStackTrace(System.err);
            }
        }
    }
}

