/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossas.servermanager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.jboss.jbossas.servermanager.JStackLikeDump;
import org.jboss.jbossas.servermanager.Server;
import org.jboss.jbossas.servermanager.ServerManager;
import org.jboss.jbossas.servermanager.ServerShutdownException;

public abstract class ServerController {
    private static final String SHUTDOWN_CLASS = "org.jboss.Shutdown";
    private static final String MAIN = "org.jboss.Main";
    private static final long PROCESS_DESTROY_DELAY = 45000L;

    private ServerController() {
    }

    public static void startServer(Server server, ServerManager manager) throws IOException {
        if (server.isRunning()) {
            throw new IllegalArgumentException("The " + server.getName() + " server is already running.");
        }
        if (ServerController.isServerStarted(server)) {
            throw new IOException("Found a process already listening on:" + server.getHttpUrl() + " or " + server.getRmiUrl());
        }
        server.setNamingContext(null);
        server.setServerConnection(null);
        ProcessBuilder startCommand = ServerController.getStartCommand(server, manager);
        System.out.println("Starting server \"" + server.getName() + "\", with command (start timeout is " + manager.getStartupTimeout() + " seconds ): \n" + Arrays.toString(startCommand.command().toArray()));
        File binDir = new File(manager.getJBossHome(), "/bin");
        startCommand.directory(binDir);
        Process process = startCommand.start();
        BufferedReader errStream = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        BufferedReader inStream = new BufferedReader(new InputStreamReader(process.getInputStream()));
        File outFile = server.getOutputLog();
        ServerController.initalizeLog(outFile);
        PrintWriter outlog = new PrintWriter(new FileWriter(outFile));
        server.setOutWriter(outlog);
        OutputPumper outPump = new OutputPumper(inStream, outlog);
        outPump.start();
        File errorFile = server.getErrorLog();
        ServerController.initalizeLog(errorFile);
        PrintWriter errorlog = new PrintWriter(new FileWriter(errorFile));
        server.setErrorWriter(errorlog);
        OutputPumper errorPump = new OutputPumper(errStream, errorlog);
        errorPump.start();
        server.setProcess(process);
        try {
            ServerController.waitForServer(server, manager);
        }
        catch (IOException e) {
            server.setProcess(null);
            throw e;
        }
        System.out.println("Server started.");
    }

    private static void initalizeLog(File logFile) throws IOException {
        if (logFile.exists()) {
            logFile.delete();
        }
        if (!logFile.getParentFile().exists()) {
            logFile.getParentFile().mkdir();
        }
        logFile.createNewFile();
    }

    private static ProcessBuilder getStartCommand(Server server, ServerManager manager) throws IOException {
        ArrayList<String> execCmd = new ArrayList<String>();
        execCmd.add(manager.getJavaExecutable());
        execCmd.add("-cp");
        execCmd.add(manager.getStartClasspath());
        execCmd.addAll(server.getJvmArgsInList());
        execCmd.addAll(server.getSysPropertiesInList());
        execCmd.add(server.getLoggingProperty());
        execCmd.add(MAIN);
        execCmd.add("-c");
        execCmd.add(server.getConfig());
        execCmd.add("-b");
        execCmd.add(server.getHost());
        execCmd.add("-g");
        execCmd.add(server.getPartition());
        String udpGroup = manager.getUdpGroup();
        if (udpGroup != null && udpGroup.length() > 0) {
            execCmd.add("-u");
            execCmd.add(udpGroup);
        }
        execCmd.addAll(server.getArgsInList());
        return new ProcessBuilder(execCmd);
    }

    private static ProcessBuilder getStopCommand(Server server, ServerManager manager) throws IOException {
        ArrayList<String> execCmd = new ArrayList<String>();
        execCmd.add(manager.getJavaExecutable());
        execCmd.add("-cp");
        execCmd.add(manager.getStopClasspath());
        execCmd.add(SHUTDOWN_CLASS);
        execCmd.add("--server");
        execCmd.add(server.getServerUrl());
        String username = server.getUsername();
        String password = server.getPassword();
        if (username != null && password != null) {
            execCmd.add("-u");
            execCmd.add(username);
            execCmd.add("-p");
            execCmd.add(password);
        }
        execCmd.add("--shutdown");
        return new ProcessBuilder(execCmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean stopServerCli(Server server, ServerManager manager, Writer log) throws IOException, InterruptedException {
        ProcessBuilder shutdownCmd = ServerController.getStopCommand(server, manager);
        System.out.println("Shutting down server: " + Arrays.toString(shutdownCmd.command().toArray()));
        shutdownCmd.redirectErrorStream(true);
        Process proc = shutdownCmd.start();
        try {
            proc.getOutputStream().close();
            BufferedReader stdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            PrintWriter output = new PrintWriter(log);
            OutputPumper pumper = new OutputPumper(stdout, output);
            pumper.start();
            pumper.join(20000L);
            Thread.sleep(500L);
            if (proc.exitValue() != 0) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IllegalThreadStateException itse) {
            boolean bl = false;
            return bl;
        }
        finally {
            proc.destroy();
            ServerController.closeAllStreams(proc);
        }
        return true;
    }

    private static void waitForServer(Server server, ServerManager manager) throws IOException {
        int tries = 0;
        while (tries++ < manager.getStartupTimeout()) {
            if (!server.isRunning()) {
                ServerController.closeAllStreams(server.getProcess());
                server.getErrorWriter().close();
                server.getOutWriter().close();
                throw new IOException("Server failed to start; see logs. exit code: " + server.getProcess().exitValue());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!ServerController.isServerStarted(server)) continue;
            return;
        }
        Process process = server.getProcess();
        ServerController.closeAllStreams(server.getProcess());
        server.getErrorWriter().close();
        server.getOutWriter().close();
        System.err.println("Failed to start server \"" + server.getName() + "\" before timeout. Destroying the process.");
        process.destroy();
        throw new IOException("Server failed to start in time; see logs.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerStarted(Server server) throws IOException {
        URL url = server.getHttpUrl();
        if (server.hasWebServer()) {
            try {
                HttpURLConnection http;
                int responseCode;
                URLConnection conn = url.openConnection();
                if (conn instanceof HttpURLConnection && (responseCode = (http = (HttpURLConnection)conn).getResponseCode()) > 0 && responseCode < 400) {
                    return true;
                }
            }
            catch (IOException e) {
                return false;
            }
            return false;
        }
        Socket socket = null;
        try {
            socket = new Socket(server.getHost(), (int)server.getRmiPort());
            boolean http = true;
            return http;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    public static void stopServer(Server server, ServerManager manager) throws IOException {
        boolean useShutdownJar = Boolean.getBoolean("sm.legacy.shutdown");
        StringWriter shutdownJarOutput = null;
        boolean cleanShutdown = true;
        Throwable shutdownException = null;
        if (!server.isRunning()) {
            throw new IllegalArgumentException("The " + server.getName() + " is not running; it cannot be stopped.");
        }
        System.out.println("Shutting down server: " + server.getName());
        try {
            if (useShutdownJar) {
                shutdownJarOutput = new StringWriter(512);
                cleanShutdown = ServerController.stopServerCli(server, manager, shutdownJarOutput);
            } else {
                server.doShutdown();
            }
        }
        catch (Throwable e) {
            shutdownException = e;
            cleanShutdown = false;
        }
        Process process = server.getProcess();
        if (cleanShutdown && !ServerController.waitOnShutdown(server, manager)) {
            cleanShutdown = false;
        }
        if (!cleanShutdown) {
            try {
                if (useShutdownJar) {
                    System.err.println(shutdownJarOutput.toString());
                } else {
                    ServerController.writeServerDump(server);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            System.err.println("Failed to shutdown server \"" + server.getName() + "\"" + (shutdownException == null ? " before timeout." : ".") + " Destroying the process.");
            process.destroy();
            try {
                Thread.sleep(45000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        ServerController.closeAllStreams(process);
        server.getErrorWriter().close();
        server.getOutWriter().close();
        server.setProcess(null);
        if (!cleanShutdown) {
            throw (ServerShutdownException)new ServerShutdownException("Failed to shutdown server" + (shutdownException == null ? " before timeout." : ".") + "Process was destroyed.").initCause(shutdownException);
        }
        System.out.println("Server stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeServerDump(Server server) throws IOException {
        String threadDump = null;
        Exception dumpException = null;
        try {
            threadDump = server.listThreadDump();
        }
        catch (Exception e) {
            dumpException = e;
        }
        if (threadDump == null) {
            System.err.print("Unable to get server thread dump: ");
            if (dumpException == null) {
                dumpException = (Exception)new RuntimeException("threadDump and dumpException null - something broken").fillInStackTrace();
            }
            dumpException.printStackTrace(System.err);
            String nl = System.getProperty("line.separator");
            StringBuffer dumps = new StringBuffer();
            Set<String> jvmPIDs = JStackLikeDump.getJVMPids(MAIN);
            for (String pid : jvmPIDs) {
                try {
                    dumps.append("===== Thread dump of " + pid + " PID").append(nl);
                    dumps.append(JStackLikeDump.getThreadDump(pid)).append(nl);
                    dumps.append("=====").append(nl);
                }
                catch (Exception e) {
                    System.err.println("Unable to get server thread dump of " + pid + " PID!");
                    e.printStackTrace(System.err);
                }
            }
            threadDump = dumps.toString();
        }
        File dumpFile = server.getDumpFile();
        System.out.println("Writing server thread dump to " + dumpFile.getAbsolutePath());
        FileWriter dumpFW = null;
        try {
            dumpFW = new FileWriter(dumpFile);
            dumpFW.write(threadDump);
            dumpFW.flush();
        }
        catch (Exception e) {
            System.err.println("Cannot write to " + dumpFile.getAbsolutePath());
            e.printStackTrace();
        }
        finally {
            if (dumpFW != null) {
                try {
                    dumpFW.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    private static boolean waitOnShutdown(Server server, ServerManager manager) {
        int shutdownTimeout = manager.getShutdownTimeout();
        System.out.println("shutdownTimeout will be=" + shutdownTimeout);
        for (int tries = 0; tries < shutdownTimeout; ++tries) {
            try {
                if (!server.isRunning()) {
                    return true;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return false;
    }

    private static void closeAllStreams(Process process) {
        try {
            process.getInputStream().close();
            process.getOutputStream().close();
            process.getErrorStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class OutputPumper
    extends Thread {
        private BufferedReader outputReader;
        private PrintWriter logWriter;

        public OutputPumper(BufferedReader outputReader, PrintWriter logWriter) {
            this.outputReader = outputReader;
            this.logWriter = logWriter;
        }

        @Override
        public void run() {
            try {
                String line = null;
                while ((line = this.outputReader.readLine()) != null) {
                    this.logWriter.println(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

