/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.jmx.adaptor.snmp.agent.Clock;
import org.jboss.jmx.adaptor.snmp.agent.Counter;
import org.jboss.jmx.adaptor.snmp.agent.Heartbeat;
import org.jboss.jmx.adaptor.snmp.agent.Reconfigurable;
import org.jboss.jmx.adaptor.snmp.agent.RequestHandler;
import org.jboss.jmx.adaptor.snmp.agent.SecurityActions;
import org.jboss.jmx.adaptor.snmp.agent.SnmpAgentServiceMBean;
import org.jboss.jmx.adaptor.snmp.agent.SnmpRequest;
import org.jboss.jmx.adaptor.snmp.agent.TrapEmitter;
import org.jboss.jmx.adaptor.snmp.config.attribute.ManagedBean;
import org.jboss.jmx.adaptor.snmp.config.notification.Mapping;
import org.jboss.jmx.adaptor.snmp.config.user.User;
import org.jboss.system.ListenerServiceMBeanSupport;
import org.jboss.xb.binding.MappingObjectModelFactory;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.snmp4j.CommandResponder;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultUdpTransportMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpAgentService
extends ListenerServiceMBeanSupport
implements SnmpAgentServiceMBean {
    public static final int SNMPV1 = 1;
    public static final int SNMPV2 = 2;
    public static final int SNMPV3 = 3;
    public static final String DEFAULT_READ_COMMUNITY = "public";
    public static final String DEFAULT_WRITE_COMMUNITY = "private";
    private Clock clock = null;
    private Counter trapCounter = null;
    private String usersResName = null;
    private String managersResName = null;
    private String notificationMapResName = null;
    private String requestHandlerResName = null;
    private String trapFactoryClassName = null;
    private String requestHandlerClassName = null;
    private String readCommunity = "public";
    private String writeCommunity = "private";
    private int numberOfThreads = 1;
    private int port = 1161;
    private int snmpVersion = 1;
    private InetAddress bindAddress;
    private ObjectName timerName = null;
    private int heartBeatPeriod = 60;
    private boolean dynamicSubscriptions = true;
    private Heartbeat heartbeat = null;
    private TrapEmitter trapEmitter = null;
    private RequestHandler requestHandler;
    private String configFileResName = null;
    private String bootCounterResName = null;
    private Snmp session;
    private TransportMapping[] transportMappings;
    private SnmpRequest responder;
    private USM usm;
    private MPv3 mpv3;
    private MessageDispatcherImpl dispatcher;
    private Map<String, User> userMap = new HashMap<String, User>();

    @Override
    public int getHeartBeatPeriod() {
        return this.heartBeatPeriod;
    }

    @Override
    public void setHeartBeatPeriod(int heartBeatPeriod) {
        this.heartBeatPeriod = heartBeatPeriod;
    }

    @Override
    public long getInstantiationTime() {
        return this.clock.instantiationTime();
    }

    @Override
    public long getUptime() {
        return this.clock.uptime();
    }

    @Override
    public long getTrapCount() {
        return this.trapCounter.peek();
    }

    @Override
    public void setManagersResName(String managersResName) {
        this.managersResName = managersResName;
    }

    @Override
    public String getManagersResName() {
        return this.managersResName;
    }

    @Override
    public void setNotificationMapResName(String notificationMapResName) {
        this.notificationMapResName = notificationMapResName;
    }

    @Override
    public String getNotificationMapResName() {
        return this.notificationMapResName;
    }

    @Override
    public void setTrapFactoryClassName(String name) {
        this.trapFactoryClassName = name;
    }

    @Override
    public String getTrapFactoryClassName() {
        return this.trapFactoryClassName;
    }

    @Override
    public void setTimerName(ObjectName timerName) {
        this.timerName = timerName;
    }

    @Override
    public ObjectName getTimerName() {
        return this.timerName;
    }

    @Override
    public void setBindAddress(String bindAddress) throws UnknownHostException {
        this.bindAddress = this.toInetAddress(bindAddress);
    }

    @Override
    public String getBindAddress() {
        String address = null;
        if (this.bindAddress != null) {
            address = this.bindAddress.getHostAddress();
        }
        return address;
    }

    @Override
    public void setNumberOfThreads(int numberOfThreads) {
        if (numberOfThreads > 0 && numberOfThreads <= 12) {
            this.numberOfThreads = numberOfThreads;
        }
    }

    @Override
    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    @Override
    public void setPort(int port) {
        if (port >= 0) {
            this.port = port;
        }
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setSnmpVersion(int snmpVersion) {
        switch (snmpVersion) {
            case 2: {
                this.snmpVersion = 2;
                break;
            }
            default: {
                this.snmpVersion = 1;
            }
        }
    }

    @Override
    public int getSnmpVersion() {
        return this.snmpVersion;
    }

    @Override
    public void setReadCommunity(String readCommunity) {
        if (readCommunity != null && readCommunity.length() > 0) {
            this.readCommunity = readCommunity;
        }
    }

    @Override
    public void setWriteCommunity(String writeCommunity) {
        if (writeCommunity != null && writeCommunity.length() > 0) {
            this.writeCommunity = writeCommunity;
        }
    }

    @Override
    public void setRequestHandlerClassName(String requestHandlerClassName) {
        this.requestHandlerClassName = requestHandlerClassName;
    }

    @Override
    public String getRequestHandlerClassName() {
        return this.requestHandlerClassName;
    }

    @Override
    public void setRequestHandlerResName(String requestHandlerResName) {
        this.requestHandlerResName = requestHandlerResName;
    }

    @Override
    public String getRequestHandlerResName() {
        return this.requestHandlerResName;
    }

    @Override
    public void setDynamicSubscriptions(boolean dynamicSubscriptions) {
        this.dynamicSubscriptions = dynamicSubscriptions;
    }

    @Override
    public boolean getDynamicSubscriptions() {
        return this.dynamicSubscriptions;
    }

    @Override
    public void reconfigureRequestHandler() throws Exception {
        if (!(this.requestHandler instanceof Reconfigurable)) {
            throw new UnsupportedOperationException("Request handler is not Reconfigurable");
        }
        ((Reconfigurable)((Object)this.requestHandler)).reconfigure(this.getRequestHandlerResName());
    }

    protected void startService() throws Exception {
        this.log.debug((Object)"Starting snmp agent ...");
        this.startAgent();
        this.log.info((Object)"SNMP agent going active");
        this.clock = new Clock();
        this.trapCounter = new Counter(0L);
        this.log.debug((Object)"Instantiating trap emitter ...");
        this.trapEmitter = new TrapEmitter(this);
        this.log.debug((Object)"Starting trap emitter ...");
        this.trapEmitter.start();
        this.heartbeat = new Heartbeat(this.getServer(), this.getTimerName(), this.getHeartBeatPeriod());
        this.log.debug((Object)"Starting heartbeat controller ...");
        this.heartbeat.start();
        super.subscribe(this.dynamicSubscriptions);
        this.sendNotification(new Notification("jboss.snmp.agent.coldstart", this, this.getNextNotificationSequenceNumber()));
    }

    protected void stopService() throws Exception {
        super.unsubscribe();
        this.log.debug((Object)"Stopping heartbeat controller ...");
        this.heartbeat.stop();
        this.heartbeat = null;
        this.log.debug((Object)"Stopping trap emitter ...");
        this.trapEmitter.stop();
        this.trapEmitter = null;
        this.log.debug((Object)"Stopping snmp agent ...");
        this.session.close();
        this.log.info((Object)"SNMP agent stopped");
    }

    public void handleNotification2(Notification n, Object handback) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received notification: <" + n + "> Payload " + "TS: <" + n.getTimeStamp() + "> " + "SN: <" + n.getSequenceNumber() + "> " + "T:  <" + n.getType() + ">"));
        }
        try {
            this.trapEmitter.send(n);
        }
        catch (Exception e) {
            this.log.error((Object)"Sending trap", (Throwable)e);
        }
    }

    private void initResponder() {
        OctetString localEngineID = new OctetString(MPv3.createLocalEngineID());
        this.responder = new SnmpRequest(this.requestHandler, this.log, localEngineID);
    }

    private void initMessageDispatcher() {
        this.dispatcher = new MessageDispatcherImpl();
        this.usm = new USM(SecurityProtocols.getInstance(), this.responder.getLocalEngineID(), 0);
        this.mpv3 = new MPv3(this.usm);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)this.usm);
        SecurityProtocols.getInstance().addDefaultProtocols();
        SecurityProtocols.getInstance().addPrivacyProtocol((PrivacyProtocol)new Priv3DES());
        this.dispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv1());
        this.dispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv2c());
        this.dispatcher.addMessageProcessingModel((MessageProcessingModel)this.mpv3);
    }

    private void initRequestHandler() throws Exception {
        this.requestHandler = (RequestHandler)Class.forName(this.requestHandlerClassName, true, this.getClass().getClassLoader()).newInstance();
        this.requestHandler.initialize(this.requestHandlerResName, this.getServer(), this.log, this.clock);
    }

    private void initTransportMapping() {
        this.transportMappings = new TransportMapping[1];
        try {
            this.transportMappings[0] = new DefaultUdpTransportMapping(new UdpAddress(this.bindAddress, this.port));
        }
        catch (Exception e) {
            this.log.debug((Object)"Exception in initialization of Tranport Map!!");
        }
    }

    private void initSession() {
        this.session = new Snmp((MessageDispatcher)this.dispatcher);
        for (int i = 0; i < this.transportMappings.length; ++i) {
            try {
                this.session.addTransportMapping(this.transportMappings[i]);
                continue;
            }
            catch (Exception e) {
                this.log.warn((Object)("Tranport mapping invalid. Failed to initialize mapping '" + this.transportMappings[i] + "' with: " + e.getMessage()));
            }
        }
        this.session.addCommandResponder((CommandResponder)this.responder);
    }

    private void addUsmUsers() throws Exception {
        MappingObjectModelFactory momf = new MappingObjectModelFactory();
        momf.mapElementToClass("user-list", ArrayList.class);
        momf.mapElementToClass("user", User.class);
        ArrayList userList = null;
        InputStream is = null;
        try {
            String resName = this.usersResName;
            is = SecurityActions.getThreadContextClassLoaderResource(resName);
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            userList = (ArrayList)unmarshaller.unmarshal(is, (ObjectModelFactory)momf, null);
        }
        catch (Exception e) {
            this.log.error((Object)("Accessing resource '" + this.usersResName + "'"));
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        for (User user : userList) {
            UsmUser usmUser = new UsmUser(new OctetString(user.getSecurityName()), user.getAuthenticationProtocolID(), new OctetString(user.getAuthenticationPassphrase()), user.getPrivacyProtocolID(), new OctetString(user.getPrivacyPassphrase()));
            this.usm.addUser(usmUser.getSecurityName(), this.usm.getLocalEngineID(), usmUser);
            this.userMap.put(user.getSecurityName(), user);
        }
    }

    private void startAgent() throws Exception {
        this.initRequestHandler();
        this.initResponder();
        this.initMessageDispatcher();
        this.initTransportMapping();
        this.initSession();
        this.addUsmUsers();
        this.session.listen();
    }

    private InetAddress toInetAddress(String host) throws UnknownHostException {
        if (host == null || host.length() == 0) {
            return null;
        }
        return InetAddress.getByName(host);
    }

    @Override
    public void setUsersResName(String usersResName) {
        this.usersResName = usersResName;
    }

    @Override
    public String getUsersResName() {
        return this.usersResName;
    }

    public Clock getClock() {
        return this.clock;
    }

    public Counter getTrapCounter() {
        return this.trapCounter;
    }

    public Map<String, User> getUserMap() {
        return this.userMap;
    }

    public Snmp getSession() {
        return this.session;
    }

    public SnmpRequest getResponder() {
        return this.responder;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public TransportMapping[] getTransportMappings() {
        return this.transportMappings;
    }

    @Override
    public void sendJMXNotification(Notification notification) {
        if (notification.getSequenceNumber() <= 0L) {
            notification.setSequenceNumber(this.getNextNotificationSequenceNumber());
        }
        try {
            this.trapEmitter.send(notification);
        }
        catch (Exception e) {
            this.log.error((Object)"Problem occured while Sending trap", (Throwable)e);
        }
    }

    @Override
    public long getNextJMXNotificationSequenceNumber() {
        return this.getNextNotificationSequenceNumber();
    }

    @Override
    public void addAttributeMappings(List<ManagedBean> mappings) {
        this.requestHandler.addAttributeMappings(mappings);
    }

    @Override
    public void removeAttributeMappings(List<ManagedBean> mappings) {
        this.requestHandler.removeAttributeMappings(mappings);
    }

    @Override
    public void addNotifications(List<Mapping> notifications) {
        this.trapEmitter.addNotifications(notifications);
    }

    @Override
    public void removeNotifications(List<Mapping> notifications) {
        this.trapEmitter.removeNotifications(notifications);
    }
}

