/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.management.Notification;
import org.jboss.jmx.adaptor.snmp.agent.MappingFailedException;
import org.jboss.jmx.adaptor.snmp.agent.NotificationWrapper;
import org.jboss.jmx.adaptor.snmp.agent.SecurityActions;
import org.jboss.jmx.adaptor.snmp.agent.SnmpAgentService;
import org.jboss.jmx.adaptor.snmp.agent.TrapFactory;
import org.jboss.jmx.adaptor.snmp.config.manager.Manager;
import org.jboss.jmx.adaptor.snmp.config.notification.Mapping;
import org.jboss.jmx.adaptor.snmp.config.notification.VarBind;
import org.jboss.jmx.adaptor.snmp.config.notification.VarBindList;
import org.jboss.jmx.adaptor.snmp.config.user.User;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.GenericObjectModelFactory;
import org.jboss.xb.binding.MappingObjectModelFactory;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.snmp4j.CommunityTarget;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrapEmitter {
    private static final Logger log = Logger.getLogger(TrapEmitter.class);
    private TrapFactory trapFactory = null;
    private SnmpAgentService snmpAgentService;
    private Set managers = Collections.synchronizedSet(new HashSet());
    private ArrayList notificationMapList = null;
    private ArrayList mappingRegExpCache = null;
    private ArrayList notificationWrapperCache = null;

    public TrapEmitter(SnmpAgentService snmpAgentService) {
        this.snmpAgentService = snmpAgentService;
    }

    public void start() throws Exception {
        this.load();
        this.trapFactory = (TrapFactory)Class.forName(this.snmpAgentService.getTrapFactoryClassName(), true, this.getClass().getClassLoader()).newInstance();
        this.trapFactory.set(this.snmpAgentService.getClock(), this.snmpAgentService.getTrapCounter(), this.snmpAgentService.getRequestHandler());
        this.trapFactory.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Set set = this.managers;
        synchronized (set) {
            this.managers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Notification n) throws Exception {
        TrapFactory trapFactory = this.trapFactory;
        synchronized (trapFactory) {
            if (this.trapFactory == null) {
                log.error((Object)"Received notifications before trap factory set. Discarding.");
                return;
            }
        }
        int index = this.findMappingIndex(n);
        if (index < 0) {
            log.debug((Object)("No SNMP notifications configured for Notification " + n.getType() + " doing nothing"));
            return;
        }
        Mapping m = (Mapping)this.notificationMapList.get(index);
        NotificationWrapper wrapper = (NotificationWrapper)this.notificationWrapperCache.get(index);
        PDUv1 v1TrapPdu = null;
        PDU v2cTrapPdu = null;
        ScopedPDU v3TrapPdu = null;
        if (this.managers.size() > 0) {
            Set set = this.managers;
            synchronized (set) {
                for (Target t : this.managers) {
                    try {
                        switch (t.getVersion()) {
                            case 0: {
                                if (v1TrapPdu == null) {
                                    v1TrapPdu = this.trapFactory.generateV1Trap(n, m, wrapper);
                                }
                                this.sendTrap((PDU)v1TrapPdu, t, m.getSecurityName());
                                break;
                            }
                            case 1: {
                                if (v2cTrapPdu == null) {
                                    v2cTrapPdu = this.trapFactory.generateV2cTrap(n, m, wrapper);
                                }
                                this.sendTrap(v2cTrapPdu, t, m.getSecurityName());
                                break;
                            }
                            case 3: {
                                if (v3TrapPdu == null) {
                                    v3TrapPdu = this.trapFactory.generateV3Trap(n, m, wrapper);
                                }
                                this.sendTrap((PDU)v3TrapPdu, t, m.getSecurityName());
                                break;
                            }
                            default: {
                                log.error((Object)"Skipping session: Unknown SNMP version found");
                                break;
                            }
                        }
                    }
                    catch (MappingFailedException e) {
                        log.error((Object)"Translating notification failed ", (Throwable)e);
                    }
                    catch (Exception e) {
                        log.error((Object)("SNMP send error for " + t.getAddress().toString()), (Throwable)e);
                    }
                }
            }
        } else {
            log.warn((Object)"No SNMP managers to send traps to");
        }
    }

    void sendTrap(PDU trap, Target target, String securityName) throws IOException {
        this.snmpAgentService.getTrapCounter().advance();
        if (target instanceof UserTarget && securityName != null) {
            if (this.snmpAgentService.getUserMap().get(securityName) == null) {
                throw new IllegalArgumentException("Notification Security Name " + securityName + " doesn't match any user defined in users.xml");
            }
            OctetString userSecurityName = new OctetString(securityName);
            ((UserTarget)target).setSecurityName(userSecurityName);
            ((UserTarget)target).setSecurityLevel(this.snmpAgentService.getUserMap().get(securityName).getSecurityLevel());
            ((UserTarget)target).setSecurityModel(3);
            if (trap.getType() == -90) {
                User user = this.snmpAgentService.getUserMap().get(securityName);
                UsmUser usmUser = new UsmUser(userSecurityName, user.getAuthenticationProtocolID(), new OctetString(user.getAuthenticationPassphrase()), user.getPrivacyProtocolID(), new OctetString(user.getPrivacyPassphrase()));
                Snmp snmp = this.createSnmpSession(target.getAddress());
                byte[] authorativeEngine = snmp.discoverAuthoritativeEngineID(target.getAddress(), 8000L);
                if (authorativeEngine != null) {
                    OctetString authorativeEngineID = new OctetString(authorativeEngine);
                    snmp.getUSM().addUser(usmUser.getSecurityName(), authorativeEngineID, usmUser);
                    ((UserTarget)target).setAuthoritativeEngineID(authorativeEngine);
                    snmp.send(trap, target);
                } else {
                    log.warn((Object)("Couldn't discover the AuthoritativeEngineID for INFORM notification " + trap));
                }
                snmp.close();
                return;
            }
        }
        this.snmpAgentService.getSession().send(trap, target);
    }

    private int findMappingIndex(Notification n) throws IndexOutOfBoundsException {
        for (int i = 0; i < this.notificationMapList.size(); ++i) {
            Matcher m;
            Pattern p = (Pattern)this.mappingRegExpCache.get(i);
            if (p == null || !(m = p.matcher(n.getType())).matches()) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Match for '" + n.getType() + "' on mapping " + i));
            }
            return i;
        }
        return -1;
    }

    private void load() throws Exception {
        log.debug((Object)("Reading resource: '" + this.snmpAgentService.getManagersResName() + "'"));
        MappingObjectModelFactory momf = new MappingObjectModelFactory();
        momf.mapElementToClass("manager-list", ArrayList.class);
        momf.mapElementToClass("manager", Manager.class);
        ArrayList managerList = null;
        InputStream is = null;
        try {
            String resName = this.snmpAgentService.getManagersResName();
            is = SecurityActions.getThreadContextClassLoaderResource(resName);
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            managerList = (ArrayList)unmarshaller.unmarshal(is, (ObjectModelFactory)momf, null);
        }
        catch (Exception e) {
            log.error((Object)("Accessing resource '" + this.snmpAgentService.getManagersResName() + "'"));
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        log.debug((Object)("Found " + managerList.size() + " monitoring managers"));
        for (Manager m : managerList) {
            this.fixManagerVersion(m);
            Target target = this.createTarget(m);
            if (target == null) {
                log.warn((Object)("createTarget: manager m: " + m.toString() + " is null!"));
                continue;
            }
            if (this.managers.add(target)) continue;
            log.warn((Object)("Ignoring duplicate manager: " + m));
        }
        log.debug((Object)("Reading resource: '" + this.snmpAgentService.getNotificationMapResName() + "'"));
        NotificationBinding omf = new NotificationBinding();
        try {
            String resName = this.snmpAgentService.getNotificationMapResName();
            is = SecurityActions.getThreadContextClassLoaderResource(resName);
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            List notifications = (List)unmarshaller.unmarshal(is, (ObjectModelFactory)omf, null);
            log.debug((Object)("Found " + notifications.size() + " notification mappings"));
            this.mappingRegExpCache = new ArrayList(notifications.size());
            this.notificationWrapperCache = new ArrayList(notifications.size());
            this.notificationMapList = new ArrayList(notifications.size());
            this.addNotifications(notifications);
        }
        catch (Exception e) {
            log.error((Object)("Accessing resource '" + this.snmpAgentService.getNotificationMapResName() + "'"));
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void addNotifications(List<Mapping> notifications) {
        for (Mapping mapping : notifications) {
            String notificationType = mapping.getNotificationType();
            try {
                Pattern re = Pattern.compile(notificationType);
                this.mappingRegExpCache.add(re);
            }
            catch (PatternSyntaxException e) {
                this.mappingRegExpCache.add(null);
                log.warn((Object)("Error compiling notification mapping for type: " + notificationType), (Throwable)e);
            }
            String wrapperClassName = mapping.getVarBindList().getWrapperClass();
            log.debug((Object)("notification wrapper class: " + wrapperClassName));
            try {
                NotificationWrapper wrapper = (NotificationWrapper)Class.forName(wrapperClassName, true, this.getClass().getClassLoader()).newInstance();
                wrapper.set(this.snmpAgentService.getClock(), this.snmpAgentService.getTrapCounter());
                this.notificationWrapperCache.add(wrapper);
            }
            catch (Exception e) {
                this.notificationWrapperCache.add(null);
                log.warn((Object)("Error compiling notification mapping for type: " + notificationType), (Throwable)e);
            }
            this.notificationMapList.add(mapping);
        }
    }

    public void removeNotifications(List<Mapping> notifications) {
        for (Mapping mapping : notifications) {
            this.notificationMapList.remove(mapping);
        }
    }

    private void fixManagerVersion(Manager m) {
        if (m != null) {
            switch (m.getVersion()) {
                case 1: {
                    m.setVersion(0);
                    break;
                }
                case 2: {
                    m.setVersion(1);
                }
            }
        }
    }

    private InetAddress toInetAddressWithDefaultBinding(String host) throws UnknownHostException {
        if (host == null || host.length() == 0) {
            String defaultBindAddress = System.getProperty("jboss.bind.address");
            if (defaultBindAddress != null && !defaultBindAddress.equals("0.0.0.0")) {
                return InetAddress.getByName(defaultBindAddress);
            }
            return InetAddress.getLocalHost();
        }
        return InetAddress.getByName(host);
    }

    private Target createTarget(Manager m) {
        int version;
        UserTarget target;
        block6: {
            target = null;
            version = m.getVersion();
            try {
                if (version == 0 || version == 1) {
                    if (m.getAddress() != null) {
                        target = new CommunityTarget((Address)new UdpAddress(InetAddress.getByName(m.getAddress()), m.getPort()), new OctetString(m.getCommunityString()));
                        target.setTimeout(8000L);
                    }
                    break block6;
                }
                if (version == 3) {
                    target = new UserTarget();
                    target.setRetries(1);
                    target.setTimeout(8000L);
                    target.setAddress((Address)new UdpAddress(InetAddress.getByName(m.getAddress()), m.getPort()));
                    break block6;
                }
                throw new IllegalArgumentException("version " + version + " is not supported in managers.xml, only 1, 2 and 3 are valid values");
            }
            catch (UnknownHostException e) {
                log.error((Object)("A problem occured creating the target towards " + m.getAddress() + ":" + m.getPort()), (Throwable)e);
            }
        }
        if (target != null) {
            target.setVersion(version);
        }
        return target;
    }

    private Snmp createSnmpSession(Address address) throws IOException {
        Object transport = address instanceof TcpAddress ? new DefaultTcpTransportMapping() : new DefaultUdpTransportMapping();
        MessageDispatcherImpl dispatcher = new MessageDispatcherImpl();
        Snmp snmp = new Snmp((MessageDispatcher)dispatcher, (TransportMapping)transport);
        OctetString localEngineID = new OctetString(MPv3.createLocalEngineID());
        USM usm = new USM(SecurityProtocols.getInstance(), localEngineID, 0);
        MPv3 mpv3 = new MPv3(usm);
        dispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv2c());
        dispatcher.addMessageProcessingModel((MessageProcessingModel)mpv3);
        snmp.listen();
        return snmp;
    }

    private static class NotificationBinding
    implements GenericObjectModelFactory {
        private NotificationBinding() {
        }

        public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
            return root;
        }

        public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
            if (root == null) {
                ArrayList notifList;
                root = notifList = new ArrayList();
            } else {
                ArrayList notifList = root;
            }
            return root;
        }

        public Object newChild(Object parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
            Object child = null;
            if ("mapping".equals(localName)) {
                Mapping m = new Mapping();
                String notificationType = attrs.getValue("notification-type");
                String generic = attrs.getValue("generic");
                String specific = attrs.getValue("specific");
                String enterprise = attrs.getValue("enterprise");
                String inform = attrs.getValue("inform");
                String securityName = attrs.getValue("security-name");
                m.setNotificationType(notificationType);
                m.setGeneric(Integer.parseInt(generic));
                m.setSpecific(Integer.parseInt(specific));
                m.setEnterprise(enterprise);
                m.setInform(Boolean.parseBoolean(inform));
                m.setSecurityName(securityName);
                child = m;
            } else if ("var-bind-list".equals(localName)) {
                VarBindList vblist = new VarBindList();
                child = vblist;
                if (attrs.getLength() > 0) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        if (!"wrapper-class".equals(attrs.getLocalName(i))) continue;
                        vblist.setWrapperClass(attrs.getValue(i));
                    }
                }
                if (vblist.getWrapperClass() == null) {
                    throw new RuntimeException("'wrapper-class' must be set at 'var-bind-list' element");
                }
            } else if ("var-bind".equals(localName)) {
                VarBind vb = new VarBind();
                String oid = attrs.getValue("oid");
                String tag = attrs.getValue("tag");
                String type = attrs.getValue("type");
                vb.setOid(oid);
                vb.setTag(tag);
                vb.setType(type);
                child = vb;
            }
            return child;
        }

        public void addChild(Object parent, Object child, UnmarshallingContext navigator, String namespaceURI, String localName) {
            if (parent instanceof ArrayList) {
                ArrayList notifList = (ArrayList)parent;
                if (child instanceof Mapping) {
                    notifList.add(child);
                }
            } else if (parent instanceof Mapping) {
                Mapping m = (Mapping)parent;
                if (child instanceof VarBindList) {
                    m.setVarBindList((VarBindList)child);
                }
            } else if (parent instanceof VarBindList) {
                VarBindList vblist = (VarBindList)parent;
                if (child instanceof VarBind) {
                    vblist.addVarBind((VarBind)child);
                }
            }
        }

        public void setValue(Object o, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
            if (o instanceof Mapping) {
                Mapping m = (Mapping)o;
                if ("notification-type".equals(localName)) {
                    m.setNotificationType(value);
                } else if ("generic".equals(localName)) {
                    m.setGeneric(Integer.parseInt(value));
                } else if ("specific".equals(localName)) {
                    m.setSpecific(Integer.parseInt(value));
                } else if ("enterprise".equals(localName)) {
                    m.setEnterprise(value);
                } else if ("inform".equals(localName)) {
                    m.setInform(Boolean.parseBoolean(value));
                } else if ("security-name".equals(localName)) {
                    m.setSecurityName(value);
                }
            } else if (o instanceof VarBind) {
                VarBind vb = (VarBind)o;
                if ("tag".equals(localName)) {
                    vb.setTag(value);
                } else if ("oid".equals(localName)) {
                    vb.setOid(value);
                }
            }
        }

        public Object completedRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName) {
            return root;
        }
    }
}

