/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import java.util.List;
import javax.management.Notification;
import org.jboss.jmx.adaptor.snmp.agent.Clock;
import org.jboss.jmx.adaptor.snmp.agent.Counter;
import org.jboss.jmx.adaptor.snmp.agent.MappingFailedException;
import org.jboss.jmx.adaptor.snmp.agent.NotificationWrapper;
import org.jboss.jmx.adaptor.snmp.agent.RequestHandler;
import org.jboss.jmx.adaptor.snmp.agent.SnmpVarBindFactory;
import org.jboss.jmx.adaptor.snmp.agent.TrapFactory;
import org.jboss.jmx.adaptor.snmp.config.notification.Mapping;
import org.jboss.jmx.adaptor.snmp.config.notification.VarBind;
import org.jboss.logging.Logger;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class TrapFactorySupport
implements TrapFactory {
    private static final Logger log = Logger.getLogger(TrapFactorySupport.class);
    private SnmpVarBindFactory snmpVBFactory = new SnmpVarBindFactory();
    private Clock clock = null;
    private Counter trapCount = null;
    private RequestHandler requestHandler = null;

    public void set(Clock clock, Counter count) {
        this.clock = clock;
        this.trapCount = count;
    }

    public void set(Clock clock, Counter count, RequestHandler rh) {
        this.clock = clock;
        this.trapCount = count;
        this.requestHandler = rh;
    }

    public void start() throws Exception {
        log.debug((Object)"Trap factory going active");
    }

    public PDUv1 generateV1Trap(Notification n, Mapping m, NotificationWrapper wrapper) throws MappingFailedException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"generateV1Trap");
        }
        PDUv1 trapPdu = new PDUv1();
        trapPdu.setTimestamp(this.clock.uptime());
        trapPdu.setType(-92);
        trapPdu.setGenericTrap(m.getGeneric());
        trapPdu.setSpecificTrap(m.getSpecific());
        trapPdu.setEnterprise(new OID(m.getEnterprise()));
        if (wrapper != null) {
            wrapper.prime(n);
            List<VarBind> vbList = m.getVarBindList().getVarBindList();
            for (int i = 0; i < vbList.size(); ++i) {
                VarBind vb = vbList.get(i);
                if (vb.getTag().matches("^a:.*")) {
                    Variable var;
                    OID oid = new OID(vb.getOid() + ".0");
                    try {
                        var = this.requestHandler.getValueFor(oid);
                    }
                    catch (Exception e) {
                        var = null;
                    }
                    if (var != null) {
                        trapPdu.add(new VariableBinding(oid, var));
                        continue;
                    }
                    trapPdu.add(this.snmpVBFactory.make(vb.getOid(), wrapper.get(vb.getTag())));
                    continue;
                }
                trapPdu.add(this.snmpVBFactory.make(vb.getOid(), wrapper.get(vb.getTag())));
            }
        } else {
            throw new MappingFailedException("Varbind mapping failure: null wrapper defined for  notification type '" + m.getNotificationType() + "'");
        }
        return trapPdu;
    }

    public PDU generateV2cTrap(Notification n, Mapping m, NotificationWrapper wrapper) throws MappingFailedException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"generateV2cTrap");
        }
        PDU trapPdu = new PDU();
        if (m.isInform()) {
            trapPdu.setType(-90);
        } else {
            trapPdu.setType(-89);
        }
        trapPdu.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)new TimeTicks(this.clock.uptime())));
        trapPdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)new OID(m.getEnterprise() + ".0." + m.getSpecific())));
        if (wrapper != null) {
            wrapper.prime(n);
            List<VarBind> vbList = m.getVarBindList().getVarBindList();
            for (int i = 0; i < vbList.size(); ++i) {
                VarBind vb = vbList.get(i);
                if (vb.getTag().matches("^a:.*")) {
                    Variable var;
                    OID oid = new OID(vb.getOid() + ".0");
                    try {
                        var = this.requestHandler.getValueFor(oid);
                    }
                    catch (Exception e) {
                        var = null;
                    }
                    if (var != null) {
                        trapPdu.add(new VariableBinding(oid, var));
                        continue;
                    }
                    trapPdu.add(this.snmpVBFactory.make(vb.getOid(), wrapper.get(vb.getTag())));
                    continue;
                }
                trapPdu.add(this.snmpVBFactory.make(vb.getOid(), wrapper.get(vb.getTag())));
            }
        } else {
            log.warn((Object)("Varbind mapping failure: null wrapper defined for  notification type '" + m.getNotificationType() + "'"));
        }
        return trapPdu;
    }

    public ScopedPDU generateV3Trap(Notification n, Mapping m, NotificationWrapper wrapper) throws MappingFailedException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"generateV3Trap");
        }
        ScopedPDU trapPdu = new ScopedPDU();
        if (m.isInform()) {
            trapPdu.setType(-90);
        } else {
            trapPdu.setType(-89);
        }
        trapPdu.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)new TimeTicks(this.clock.uptime())));
        trapPdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)new OID(m.getEnterprise() + ".0." + m.getSpecific())));
        if (wrapper != null) {
            wrapper.prime(n);
            List<VarBind> vbList = m.getVarBindList().getVarBindList();
            for (int i = 0; i < vbList.size(); ++i) {
                VarBind vb = vbList.get(i);
                if (vb.getTag().matches("^a:.*")) {
                    Variable var;
                    OID oid = new OID(vb.getOid() + ".0");
                    try {
                        var = this.requestHandler.getValueFor(oid);
                    }
                    catch (Exception e) {
                        var = null;
                    }
                    if (var != null) {
                        trapPdu.add(new VariableBinding(oid, var));
                        continue;
                    }
                    trapPdu.add(this.snmpVBFactory.make(vb.getOid(), wrapper.get(vb.getTag())));
                    continue;
                }
                trapPdu.add(this.snmpVBFactory.make(vb.getOid(), wrapper.get(vb.getTag())));
            }
        } else {
            log.warn((Object)("Varbind mapping failure: null wrapper defined for  notification type '" + m.getNotificationType() + "'"));
        }
        return trapPdu;
    }
}

