/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.system;

import javax.management.ObjectName;
import org.jboss.jmx.adaptor.snmp.agent.SnmpAgentServiceMBean;
import org.jboss.jmx.adaptor.snmp.system.MIB2SystemGroupServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigLocator;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.TimeTicks;

public class MIB2SystemGroupService
extends ServiceMBeanSupport
implements MIB2SystemGroupServiceMBean {
    public static final String JBOSS_PREFIX = "1.3.6.1.4.1.2312.100";
    private String product;
    private String version;
    private String sysDescr;
    private OID sysObjectId;
    private String sysContact;
    private String sysName;
    private String sysLocation;
    private final int sysServices = 64;
    private ObjectName snmpAgent = SnmpAgentServiceMBean.OBJECT_NAME;

    public void setProduct(String product) {
        this.product = product;
    }

    public String getProduct() {
        return this.product;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setSnmpAgent(ObjectName agent) {
        this.snmpAgent = agent;
    }

    public ObjectName getSnmpAgent() {
        return this.snmpAgent;
    }

    public void setSysDescr(String sysDescr) {
        this.sysDescr = sysDescr;
    }

    public String getSysDescr() {
        return this.sysDescr;
    }

    public OID getSysObjectId() {
        return this.sysObjectId;
    }

    public TimeTicks getSysUpTime() {
        if (this.snmpAgent != null) {
            try {
                Long upTime = (Long)this.server.getAttribute(this.snmpAgent, "Uptime");
                return new TimeTicks(upTime / 10L);
            }
            catch (Exception e) {
                this.log.debug((Object)"Can't get uptime value from agent");
            }
        }
        return new TimeTicks(System.currentTimeMillis() / 10L);
    }

    public void setSysContact(String sysContact) {
        this.sysContact = sysContact;
    }

    public String getSysContact() {
        return this.sysContact;
    }

    public void setSysName(String sysName) {
        this.sysName = sysName;
    }

    public String getSysName() {
        return this.sysName;
    }

    public void setSysLocation(String sysLocation) {
        this.sysLocation = sysLocation;
    }

    public String getSysLocation() {
        return this.sysLocation;
    }

    public int getSysServices() {
        return 64;
    }

    protected void createService() throws Exception {
        if (this.sysName == null) {
            String serverConfig = ServerConfigLocator.locate().getServerName();
            ObjectName name = new ObjectName("jboss.system:type=ServerInfo");
            String hostAddress = (String)this.server.getAttribute(name, "HostAddress");
            this.sysName = serverConfig + "@" + hostAddress;
            this.log.debug((Object)("Setting sysName name to " + this.sysName));
        }
        this.sysObjectId = new OID(JBOSS_PREFIX + this.product + this.version);
    }
}

