/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.test;

import java.io.IOException;
import java.net.UnknownHostException;
import javax.management.Notification;
import org.jboss.jmx.adaptor.snmp.test.NotificationProducerServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class NotificationProducerService
extends ServiceMBeanSupport
implements NotificationProducerServiceMBean {
    public final String V1_TEST_NOTIFICATION = "jboss.snmp.agent.v1test";
    public final String V2_TEST_NOTIFICATION = "jboss.snmp.agent.v2test";
    public final String V3_TEST_NOTIFICATION = "jboss.snmp.agent.v3test";

    public void sendV1() throws Exception {
        this.log.debug((Object)"Sending SnmpV1 test notification");
        this.sendNotification(new Notification("jboss.snmp.agent.v1test", (Object)this, this.getNextNotificationSequenceNumber(), "V1 test notifications"));
    }

    public void sendV2() throws Exception {
        this.log.debug((Object)"Sending SnmpV2 test notification");
        this.sendNotification(new Notification("jboss.snmp.agent.v2test", (Object)this, this.getNextNotificationSequenceNumber(), "V2 test notifications"));
    }

    public void sendV3() throws Exception {
        this.log.debug((Object)"Sending SnmpV3 test notification");
        this.sendNotification(new Notification("jboss.snmp.agent.v3test", (Object)this, this.getNextNotificationSequenceNumber(), "V3 test notifications"));
    }

    public void getBulk() {
        this.log.debug((Object)"Executing GETBULK...");
        PDU pdu = new PDU();
        pdu.setType(-91);
        pdu.add(new VariableBinding(new OID("1.2.3.4.1.1")));
        pdu.add(new VariableBinding(new OID("1.3.6.1.2.1.1.0")));
        pdu.add(new VariableBinding(new OID("1.3.1.1")));
        pdu.setMaxRepetitions(7);
        pdu.setNonRepeaters(1);
        CommunityTarget target = new CommunityTarget();
        OctetString community = new OctetString("public");
        target.setCommunity(community);
        target.setVersion(1);
        Address targetAddress = GenericAddress.parse((String)"udp:127.0.0.1/1161");
        target.setAddress(targetAddress);
        target.setRetries(2);
        target.setTimeout(2000L);
        try {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            transport.listen();
            System.out.println("READY: " + System.currentTimeMillis());
            Snmp snmp = new Snmp((TransportMapping)transport);
            ResponseEvent responseEvent = snmp.send(pdu, (Target)target);
            System.out.println("response " + responseEvent.toString());
            PDU responsePDU = responseEvent.getResponse();
            if (responsePDU == null) {
                System.out.println("Request timed out");
            } else {
                System.out.println("Received response " + responsePDU);
            }
            System.out.println("Peer Address: " + responseEvent.getPeerAddress());
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Some Other exception!!");
        }
    }

    public void getNext() {
        PDU pdu = new PDU();
        pdu.setType(-95);
        pdu.add(new VariableBinding(new OID("1.3.6.1.2.1.1")));
        CommunityTarget target = new CommunityTarget();
        OctetString community = new OctetString("public");
        target.setCommunity(community);
        target.setVersion(1);
        Address targetAddress = GenericAddress.parse((String)"udp:127.0.0.1/1161");
        target.setAddress(targetAddress);
        target.setRetries(2);
        target.setTimeout(2000L);
        try {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            transport.listen();
            System.out.println("READY: " + System.currentTimeMillis());
            Snmp snmp = new Snmp((TransportMapping)transport);
            ResponseEvent responseEvent = snmp.send(pdu, (Target)target);
            System.out.println("response " + responseEvent.toString());
            PDU responsePDU = responseEvent.getResponse();
            if (responsePDU == null) {
                System.out.println("Request timed out");
            } else {
                System.out.println("Received response " + responsePDU);
            }
            System.out.println("Peer Address: " + responseEvent.getPeerAddress());
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Some Other exception!!");
        }
    }

    public void get() {
        PDU pdu = new PDU();
        pdu.setType(-96);
        pdu.add(new VariableBinding(new OID("1.3.6.1.2.1.1.4")));
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString("public"));
        target.setVersion(1);
        Address targetAddress = GenericAddress.parse((String)"udp:127.0.0.1/1161");
        target.setAddress(targetAddress);
        target.setRetries(2);
        target.setTimeout(2000L);
        try {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            transport.listen();
            System.out.println("READY: " + System.currentTimeMillis());
            Snmp snmp = new Snmp((TransportMapping)transport);
            ResponseEvent responseEvent = snmp.send(pdu, (Target)target);
            System.out.println("response " + responseEvent.toString());
            PDU responsePDU = responseEvent.getResponse();
            if (responsePDU == null) {
                System.out.println("Request timed out");
            }
            System.out.println("Peer Address: " + responseEvent.getPeerAddress());
            System.out.println("responsePdu = " + responsePDU);
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Some Other exception!!" + e);
        }
    }

    public void set() {
        PDU pdu = new PDU();
        pdu.add(new VariableBinding(new OID("1.3.6.1.2.1.1.1"), (Variable)new OctetString("MBean Set Test")));
        pdu.setType(-93);
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString("private"));
        target.setVersion(1);
        Address targetAddress = GenericAddress.parse((String)"udp:127.0.0.1/1161");
        target.setAddress(targetAddress);
        target.setRetries(2);
        target.setTimeout(1000L);
        try {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            transport.listen();
            System.out.println("READY: " + System.currentTimeMillis());
            Snmp snmp = new Snmp((TransportMapping)transport);
            ResponseEvent responseEvent = snmp.set(pdu, (Target)target);
            System.out.println("response " + responseEvent.toString());
            PDU responsePDU = responseEvent.getResponse();
            if (responsePDU == null) {
                System.out.println("Request timed out.");
            } else {
                System.out.println("Received response " + responsePDU);
            }
            System.out.println("Peer Address: " + responseEvent.getPeerAddress());
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Some Other exception!!");
        }
    }
}

