/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.config.user;

import org.jboss.jmx.adaptor.snmp.config.user.AuthenticationProtocol;
import org.jboss.jmx.adaptor.snmp.config.user.PrivacyProtocol;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.smi.OID;

public class User {
    private String securityName;
    private String authenticationProtocol;
    private String authenticationPassphrase;
    private String privacyProtocol;
    private String privacyPassphrase;
    private int securityLevel;

    public void setSecurityName(String securityName) {
        this.securityName = securityName;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public void setAuthenticationProtocol(String authenticationProtocol) {
        this.authenticationProtocol = authenticationProtocol;
    }

    public String getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    public OID getAuthenticationProtocolID() {
        AuthenticationProtocol authenticationProtocolID = AuthenticationProtocol.valueOf(this.authenticationProtocol.trim());
        switch (authenticationProtocolID) {
            case MD5: {
                return AuthMD5.ID;
            }
            case SHA: {
                return AuthSHA.ID;
            }
        }
        return null;
    }

    public void setAuthenticationPassphrase(String authenticationPassphrase) {
        this.authenticationPassphrase = authenticationPassphrase;
    }

    public String getAuthenticationPassphrase() {
        return this.authenticationPassphrase;
    }

    public void setPrivacyProtocol(String privacyProtocol) {
        this.privacyProtocol = privacyProtocol;
    }

    public String getPrivacyProtocol() {
        return this.privacyProtocol;
    }

    public OID getPrivacyProtocolID() {
        PrivacyProtocol privacyProtocolID = PrivacyProtocol.valueOf(this.privacyProtocol.trim());
        switch (privacyProtocolID) {
            case DES: {
                return PrivDES.ID;
            }
            case TRIPLE_DES: {
                return Priv3DES.ID;
            }
            case AES128: {
                return PrivAES128.ID;
            }
            case AES192: {
                return PrivAES192.ID;
            }
            case AES256: {
                return PrivAES256.ID;
            }
        }
        return null;
    }

    public void setPrivacyPassphrase(String privacyPassphrase) {
        this.privacyPassphrase = privacyPassphrase;
    }

    public String getPrivacyPassphrase() {
        return this.privacyPassphrase;
    }

    public int getSecurityLevel() {
        if (this.authenticationProtocol == null) {
            return 1;
        }
        if (this.privacyProtocol == null) {
            return 2;
        }
        return 3;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(256);
        sbuf.append('[').append("securityName=").append(this.securityName).append(", authenticationProtocol=").append(this.authenticationProtocol).append(", authenticationPassphrase=").append(this.authenticationPassphrase).append(", privacyProtocol=").append(this.privacyProtocol).append(", privacyPassphrase=").append(this.privacyPassphrase).append(']');
        return sbuf.toString();
    }
}

