/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;
import org.osgi.framework.BundleContext;

public abstract class AbstractWebConsolePlugin
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String ATTR_FILEUPLOAD = "org.apache.felix.webconsole.fileupload";
    private BundleContext bundleContext;
    private String adminTitle;
    private String productName;
    private String productWeb;
    private String vendorName;

    protected String getHeader() {
        String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"text/html; utf-8\"><link rel=\"icon\" href=\"{6}/res/imgs/favicon.ico\"><title>{0} - {2}</title><script src=\"{5}/res/ui/jquery-1.3.2.min.js\" language=\"JavaScript\"></script><script src=\"{5}/res/ui/jquery.tablesorter-2.0.3.min.js\" language=\"JavaScript\"></script><script src=\"{5}/res/ui/admin.js\" language=\"JavaScript\"></script><script src=\"{5}/res/ui/ui.js\" language=\"JavaScript\"></script><script language=\"JavaScript\">appRoot = \"{5}\";pluginRoot = appRoot + \"/{6}\";</script><link href=\"{5}/res/ui/admin.css\" rel=\"stylesheet\" type=\"text/css\"></head><body><div id=\"main\"><div id=\"lead\"><h1>{0}<br>{2}</h1><p><a target=\"_blank\" href=\"{3}\" title=\"{1}\"><img src=\"{5}/res/imgs/logo.png\" width=\"165\" height=\"63\" border=\"0\"></a></p></div>";
        return HEADER;
    }

    public String getServletName() {
        return this.getTitle();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = this.startResponse(request, response);
        this.renderTopNavigation(request, pw);
        this.renderContent(request, response);
        this.endResponse(request, pw);
    }

    public void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        Dictionary headers = bundleContext.getBundle().getHeaders();
        this.adminTitle = (String)headers.get("Bundle-Name");
        this.productName = "Apache Felix";
        this.productWeb = (String)headers.get("Bundle-DocURL");
        this.vendorName = (String)headers.get("Bundle-Vendor");
    }

    public void deactivate() {
        this.bundleContext = null;
    }

    public abstract String getTitle();

    public abstract String getLabel();

    protected abstract void renderContent(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected PrintWriter startResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html");
        PrintWriter pw = response.getWriter();
        String header = MessageFormat.format(this.getHeader(), this.adminTitle, this.productName, this.getTitle(), this.productWeb, this.vendorName, (String)request.getAttribute(OsgiManager.ATTR_APP_ROOT), this.getLabel());
        pw.println(header);
        return pw;
    }

    protected void renderTopNavigation(HttpServletRequest request, PrintWriter pw) {
        boolean linkToCurrent = true;
        String current = request.getPathInfo();
        int slash = current.indexOf("/", 1);
        if (slash < 0) {
            slash = current.length();
            linkToCurrent = false;
        }
        current = current.substring(1, slash);
        boolean disabled = false;
        String appRoot = (String)request.getAttribute(OsgiManager.ATTR_APP_ROOT);
        Map labelMap = (Map)request.getAttribute(OsgiManager.ATTR_LABEL_MAP);
        if (labelMap != null) {
            pw.println("<div id='technav'>");
            TreeMap map = new TreeMap();
            for (Map.Entry labelMapEntry : labelMap.entrySet()) {
                if (labelMapEntry.getKey() == null) continue;
                if (disabled || current.equals(labelMapEntry.getKey())) {
                    if (linkToCurrent) {
                        map.put(labelMapEntry.getValue(), "<a class='technavat' href='" + appRoot + "/" + labelMapEntry.getKey() + "'>" + labelMapEntry.getValue() + "</a>");
                        continue;
                    }
                    map.put(labelMapEntry.getValue(), "<span class='technavat'>" + labelMapEntry.getValue() + "</span>");
                    continue;
                }
                map.put(labelMapEntry.getValue(), "<a href='" + appRoot + "/" + labelMapEntry.getKey() + "'>" + labelMapEntry.getValue() + "</a>");
            }
            Iterator li = map.values().iterator();
            while (li.hasNext()) {
                pw.print("<nobr>");
                pw.print(li.next());
                pw.println("</nobr>");
            }
            pw.println("</div>");
        }
    }

    protected void endResponse(HttpServletRequest request, PrintWriter pw) {
        pw.println("</body>");
        pw.println("</html>");
    }

    public static String getParameter(HttpServletRequest request, String name) {
        FileItem[] param;
        if (!ServletFileUpload.isMultipartContent((RequestContext)new ServletRequestContext(request))) {
            return request.getParameter(name);
        }
        HashMap<String, FileItem[]> params = (HashMap<String, FileItem[]>)request.getAttribute(ATTR_FILEUPLOAD);
        if (params == null) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(256000);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setSizeMax(-1L);
            params = new HashMap<String, FileItem[]>();
            try {
                List items = upload.parseRequest(request);
                for (FileItem fi : items) {
                    FileItem[] current = (FileItem[])params.get(fi.getFieldName());
                    if (current == null) {
                        current = new FileItem[]{fi};
                    } else {
                        FileItem[] newCurrent = new FileItem[current.length + 1];
                        System.arraycopy(current, 0, newCurrent, 0, current.length);
                        newCurrent[current.length] = fi;
                        current = newCurrent;
                    }
                    params.put(fi.getFieldName(), current);
                }
            }
            catch (FileUploadException fue) {
                // empty catch block
            }
            request.setAttribute(ATTR_FILEUPLOAD, params);
        }
        if ((param = (FileItem[])params.get(name)) != null) {
            for (int i = 0; i < param.length; ++i) {
                if (!param[i].isFormField()) continue;
                return param[i].getString();
            }
        }
        return null;
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String redirectUrl) throws IOException {
        if (!redirectUrl.startsWith("/")) {
            String base = request.getContextPath() + request.getServletPath() + request.getPathInfo();
            int i = base.lastIndexOf(47);
            if (i > -1) {
                base = base.substring(0, i);
            } else {
                i = base.indexOf(58);
                String string = base = i > -1 ? base.substring(i + 1, base.length()) : "";
            }
            if (!base.startsWith("/")) {
                base = '/' + base;
            }
            redirectUrl = base + '/' + redirectUrl;
        }
        response.sendRedirect(redirectUrl);
    }
}

