/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.blueprint.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.aries.blueprint.utils.JavaUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlueprintEventDispatcher
implements BlueprintListener,
SynchronousBundleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlueprintEventDispatcher.class);
    private final Set<BlueprintListener> listeners = new CopyOnWriteArraySet<BlueprintListener>();
    private final Map<Bundle, BlueprintEvent> states = new ConcurrentHashMap<Bundle, BlueprintEvent>();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final ExecutorService sharedExecutor;
    private final EventAdminListener eventAdminListener;
    private final ServiceTracker containerListenerTracker;

    BlueprintEventDispatcher(final BundleContext bundleContext, ExecutorService sharedExecutor) {
        assert (bundleContext != null);
        assert (sharedExecutor != null);
        this.sharedExecutor = sharedExecutor;
        bundleContext.addBundleListener((BundleListener)this);
        EventAdminListener listener = null;
        try {
            this.getClass().getClassLoader().loadClass("org.osgi.service.event.EventAdmin");
            listener = new EventAdminListener(bundleContext);
        }
        catch (Throwable t) {
            LOGGER.debug("EventAdmin package is not available, just don't use it");
        }
        this.eventAdminListener = listener;
        this.containerListenerTracker = new ServiceTracker(bundleContext, BlueprintListener.class.getName(), new ServiceTrackerCustomizer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object addingService(ServiceReference reference) {
                BlueprintListener listener = (BlueprintListener)bundleContext.getService(reference);
                Set set = BlueprintEventDispatcher.this.listeners;
                synchronized (set) {
                    BlueprintEventDispatcher.this.sendInitialEvents(listener);
                    BlueprintEventDispatcher.this.listeners.add(listener);
                }
                return listener;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                BlueprintEventDispatcher.this.listeners.remove(service);
                bundleContext.ungetService(reference);
            }
        });
        this.containerListenerTracker.open();
    }

    private void sendInitialEvents(BlueprintListener listener) {
        for (Map.Entry<Bundle, BlueprintEvent> entry : this.states.entrySet()) {
            try {
                this.callListener(listener, new BlueprintEvent(entry.getValue(), true));
            }
            catch (RejectedExecutionException ree) {
                LOGGER.warn("Executor shut down", (Throwable)ree);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blueprintEvent(final BlueprintEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending blueprint container event {} for bundle {}", (Object)BlueprintEventDispatcher.toString(event), (Object)event.getBundle().getSymbolicName());
        }
        Set<BlueprintListener> set = this.listeners;
        synchronized (set) {
            this.callListeners(event);
            this.states.put(event.getBundle(), event);
        }
        if (this.eventAdminListener != null) {
            try {
                this.sharedExecutor.submit(new Runnable(){

                    public void run() {
                        BlueprintEventDispatcher.this.eventAdminListener.blueprintEvent(event);
                    }
                });
            }
            catch (RejectedExecutionException ree) {
                LOGGER.warn("Executor shut down", (Throwable)ree);
            }
        }
    }

    private static String toString(BlueprintEvent event) {
        return "BlueprintEvent[type=" + BlueprintEventDispatcher.getEventType(event.getType()) + (event.getDependencies() != null ? ", dependencies=" + Arrays.asList(event.getDependencies()) : "") + (event.getCause() != null ? ", exception=" + event.getCause().getMessage() : "") + "]";
    }

    private static String getEventType(int type) {
        switch (type) {
            case 1: {
                return "CREATING";
            }
            case 2: {
                return "CREATED";
            }
            case 3: {
                return "DESTROYING";
            }
            case 4: {
                return "DESTROYED";
            }
            case 5: {
                return "FAILURE";
            }
            case 6: {
                return "GRACE_PERIOD";
            }
            case 7: {
                return "WAITING";
            }
        }
        return "UNKNOWN";
    }

    private void callListeners(BlueprintEvent event) {
        for (BlueprintListener listener : this.listeners) {
            try {
                this.callListener(listener, event);
            }
            catch (RejectedExecutionException ree) {
                LOGGER.warn("Executor shut down", (Throwable)ree);
                break;
            }
        }
    }

    private void callListener(final BlueprintListener listener, final BlueprintEvent event) throws RejectedExecutionException {
        try {
            this.executor.invokeAny(Collections.singleton(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    listener.blueprintEvent(event);
                    return null;
                }
            }), 60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            LOGGER.warn("Thread interrupted", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException te) {
            LOGGER.warn("Listener timed out, will be ignored", (Throwable)te);
            this.listeners.remove(listener);
        }
        catch (ExecutionException ee) {
            LOGGER.warn("Listener caused an exception, will be ignored", (Throwable)ee);
            this.listeners.remove(listener);
        }
    }

    void destroy() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.containerListenerTracker.close();
        if (this.eventAdminListener != null) {
            this.eventAdminListener.destroy();
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (256 == event.getType()) {
            this.states.remove(event.getBundle());
        }
    }

    private static class EventAdminListener
    implements BlueprintListener {
        private final ServiceTracker tracker;

        EventAdminListener(BundleContext context) {
            this.tracker = new ServiceTracker(context, EventAdmin.class.getName(), null);
            this.tracker.open();
        }

        public void blueprintEvent(BlueprintEvent event) {
            String topic;
            EventAdmin eventAdmin = (EventAdmin)this.tracker.getService();
            if (eventAdmin == null) {
                return;
            }
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("type", event.getType());
            ((Dictionary)props).put("event", event);
            ((Dictionary)props).put("timestamp", event.getTimestamp());
            ((Dictionary)props).put("bundle", event.getBundle());
            ((Dictionary)props).put("bundle.symbolicName", event.getBundle().getSymbolicName());
            ((Dictionary)props).put("bundle.id", event.getBundle().getBundleId());
            ((Dictionary)props).put("bundle.version", JavaUtils.getBundleVersion((Bundle)event.getBundle()));
            ((Dictionary)props).put("extender.bundle", event.getExtenderBundle());
            ((Dictionary)props).put("extender.bundle.id", event.getExtenderBundle().getBundleId());
            ((Dictionary)props).put("extender.bundle.symbolicName", event.getExtenderBundle().getSymbolicName());
            ((Dictionary)props).put("extender.bundle.version", JavaUtils.getBundleVersion((Bundle)event.getExtenderBundle()));
            if (event.getCause() != null) {
                ((Dictionary)props).put("cause", event.getCause());
            }
            if (event.getDependencies() != null) {
                ((Dictionary)props).put("dependencies", event.getDependencies());
            }
            switch (event.getType()) {
                case 1: {
                    topic = "org/osgi/service/blueprint/container/CREATING";
                    break;
                }
                case 2: {
                    topic = "org/osgi/service/blueprint/container/CREATED";
                    break;
                }
                case 3: {
                    topic = "org/osgi/service/blueprint/container/DESTROYING";
                    break;
                }
                case 4: {
                    topic = "org/osgi/service/blueprint/container/DESTROYED";
                    break;
                }
                case 5: {
                    topic = "org/osgi/service/blueprint/container/FAILURE";
                    break;
                }
                case 6: {
                    topic = "org/osgi/service/blueprint/container/GRACE_PERIOD";
                    break;
                }
                case 7: {
                    topic = "org/osgi/service/blueprint/container/WAITING";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown blueprint event type: " + event.getType());
                }
            }
            eventAdmin.postEvent(new Event(topic, props));
        }

        public void destroy() {
            this.tracker.close();
        }
    }
}

