/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.metadata.internal;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.jboss.classloading.spi.version.VersionComparator;
import org.jboss.osgi.framework.metadata.VersionRange;
import org.osgi.framework.Version;

public class AbstractVersionRange
extends org.jboss.classloading.spi.version.VersionRange
implements VersionRange,
Serializable {
    private static final long serialVersionUID = -178825219621278882L;

    public static AbstractVersionRange valueOf(String rangeSpec) {
        return AbstractVersionRange.parseRangeSpec(rangeSpec);
    }

    public static AbstractVersionRange parseRangeSpec(String rangeSpec) {
        if (rangeSpec == null) {
            throw new IllegalArgumentException("Null rangeSpec");
        }
        if (rangeSpec.startsWith("\"") && rangeSpec.endsWith("\"")) {
            rangeSpec = rangeSpec.substring(1, rangeSpec.length() - 1);
        }
        Version floor = null;
        Version ceiling = null;
        StringTokenizer st = new StringTokenizer(rangeSpec, ",[]()", true);
        Boolean floorIsGreaterThan = null;
        Boolean ceilingIsLessThan = null;
        boolean mid = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("[")) {
                floorIsGreaterThan = false;
                continue;
            }
            if (token.equals("(")) {
                floorIsGreaterThan = true;
                continue;
            }
            if (token.equals("]")) {
                ceilingIsLessThan = false;
                continue;
            }
            if (token.equals(")")) {
                ceilingIsLessThan = true;
                continue;
            }
            if (token.equals(",")) {
                mid = true;
                continue;
            }
            if (token.equals("\"")) continue;
            if (floor == null) {
                floor = new Version(token);
                continue;
            }
            ceiling = new Version(token);
        }
        if (floorIsGreaterThan == null || ceilingIsLessThan == null) {
            if (mid) {
                throw new IllegalArgumentException("Missing parenthesis: " + rangeSpec);
            }
            floorIsGreaterThan = false;
            ceilingIsLessThan = false;
        }
        return new AbstractVersionRange(floor, ceiling, floorIsGreaterThan, ceilingIsLessThan);
    }

    public AbstractVersionRange(Version floor, Version ceiling, boolean floorIsLessThan, boolean ceilingIsLessThan) {
        super((Object)(floor == null ? Version.emptyVersion : floor), !floorIsLessThan, (Object)ceiling, !ceilingIsLessThan);
    }

    public Version getFloor() {
        return (Version)this.getLow();
    }

    public Version getCeiling() {
        return (Version)this.getHigh();
    }

    public boolean isInRange(Version v) {
        return super.isInRange((Object)v);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OSGiVersionToStringComparator
    implements VersionComparator<Version, String> {
        public int compare(Version t, String u) {
            return t.compareTo((Object)Version.parseVersion((String)u));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OSGiVersionToVersionComparator
    implements VersionComparator<Version, org.jboss.classloading.spi.version.Version> {
        public int compare(Version t, org.jboss.classloading.spi.version.Version u) {
            int result = t.getMajor() - u.getMajor();
            if (result != 0) {
                return result;
            }
            result = t.getMinor() - u.getMinor();
            if (result != 0) {
                return result;
            }
            result = t.getMicro() - u.getMicro();
            if (result != 0) {
                return result;
            }
            String q1 = t.getQualifier();
            String q2 = u.getQualifier();
            return q1.compareTo(q2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OSGiVersionToOSGiVersionComparator
    implements VersionComparator<Version, Version> {
        public int compare(Version t, Version u) {
            return t.compareTo((Object)u);
        }
    }
}

