/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.classloading;

import org.jboss.classloader.plugins.filter.CombiningClassFilter;
import org.jboss.classloader.plugins.jdk.AbstractJDKChecker;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.ClassFilterUtils;
import org.jboss.classloader.spi.filter.RecursivePackageClassFilter;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.classloading.OSGiBundleClassLoader;
import org.jboss.osgi.framework.classloading.OSGiClassLoaderDomain;
import org.jboss.osgi.framework.classloading.OSGiCoreClassFilter;

public class OSGiClassLoaderSystem
extends ClassLoaderSystem {
    public OSGiClassLoaderSystem() {
        ClassLoaderDomain domain = this.getDefaultDomain();
        RecursivePackageClassFilter javaFilter = RecursivePackageClassFilter.createRecursivePackageClassFilter((String[])new String[]{"java"});
        CombiningClassFilter filter = CombiningClassFilter.create((ClassFilter[])new ClassFilter[]{javaFilter, OSGiCoreClassFilter.INSTANCE});
        domain.setParentPolicy(new ParentPolicy((ClassFilter)filter, ClassFilterUtils.NOTHING));
        AbstractJDKChecker.getExcluded().add(AbstractBundleState.class);
        AbstractJDKChecker.getExcluded().add(OSGiBundleState.class);
    }

    protected ClassLoaderDomain createDomain(String name) {
        return new OSGiClassLoaderDomain(name);
    }

    protected BaseClassLoader createClassLoader(ClassLoaderPolicy policy) {
        return new OSGiBundleClassLoader(policy);
    }
}

