/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.tracker.ContextTracker;
import org.jboss.dependency.spi.tracker.ContextTracking;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.ControllerContextHandle;
import org.jboss.osgi.framework.bundle.MDRUtils;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.plugins.ControllerContextPlugin;
import org.jboss.osgi.framework.util.KernelUtils;
import org.osgi.framework.Bundle;

class GenericServiceReferenceWrapper
extends ControllerContextHandle {
    private ControllerContext context;
    private AbstractBundleState bundleState;

    public GenericServiceReferenceWrapper(ControllerContext context, AbstractBundleState bundleState) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundle state");
        }
        this.context = context;
        this.bundleState = bundleState;
    }

    ControllerContext getContext() {
        return this.context;
    }

    public Object getProperty(String key) {
        return MDRUtils.getProperty(this.context, key, Object.class);
    }

    public String[] getPropertyKeys() {
        Dictionary<String, Object> dictionary = MDRUtils.getProperties(this.context);
        String[] keys = new String[dictionary.size()];
        int i = 0;
        Enumeration<String> e = dictionary.keys();
        while (e.hasMoreElements()) {
            keys[i++] = e.nextElement();
        }
        return keys;
    }

    public Bundle getBundle() {
        if (KernelUtils.isUnregistered(this.context)) {
            return null;
        }
        return this.bundleState.getBundleInternal();
    }

    public Bundle[] getUsingBundles() {
        if (this.context instanceof ContextTracking) {
            ContextTracking tracking = (ContextTracking)this.context;
            ContextTracker ct = tracking.getContextTracker();
            if (ct == null) {
                return null;
            }
            OSGiBundleManager manager = this.bundleState.getBundleManager();
            ControllerContextPlugin plugin = manager.getPlugin(ControllerContextPlugin.class);
            Set users = ct.getUsers(this.context);
            HashSet<Bundle> bundles = new HashSet<Bundle>();
            for (Object user : users) {
                AbstractBundleState abs = plugin.getBundleForUser(user);
                bundles.add(abs.getBundleInternal());
            }
            if (!bundles.isEmpty()) {
                return bundles.toArray(new Bundle[bundles.size()]);
            }
        }
        return null;
    }

    public boolean isAssignableTo(Bundle bundle, String className) {
        AbstractBundleState targetBundle = AbstractBundleState.assertBundleState(bundle);
        return MDRUtils.isAssignableTo(this.context, this.bundleState, targetBundle, className);
    }

    public int compareTo(Object obj) {
        return MDRUtils.compareTo(this.context, obj);
    }

    public int hashCode() {
        return this.context.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GenericServiceReferenceWrapper)) {
            return false;
        }
        GenericServiceReferenceWrapper other = (GenericServiceReferenceWrapper)obj;
        return this.context == other.context;
    }

    public String toString() {
        return this.context.toString();
    }
}

