/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.Dictionary;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.Kernel;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalFactory;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.osgi.framework.bundle.DictionaryFactory;

public class InstanceMetaDataRetrievalFactory
implements MetaDataRetrievalFactory {
    private Controller controller;
    private MutableMetaDataRepository repository;
    private Set<DictionaryFactory> factories = new CopyOnWriteArraySet<DictionaryFactory>();

    public InstanceMetaDataRetrievalFactory(Kernel kernel) {
        if (kernel == null) {
            throw new IllegalArgumentException("Null kernel");
        }
        this.controller = kernel.getController();
        this.repository = kernel.getMetaDataRepository().getMetaDataRepository();
    }

    public MetaDataRetrieval getMetaDataRetrieval(Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Null scope");
        }
        if (!CommonLevels.INSTANCE.equals((Object)scope.getScopeLevel())) {
            throw new IllegalArgumentException("Not an instance scope: " + scope);
        }
        ScopeKey key = new ScopeKey(scope);
        MemoryMetaDataLoader loader = new MemoryMetaDataLoader(key.getOptimizedKey());
        this.repository.addMetaDataRetrieval((MetaDataRetrieval)loader);
        Object qualifier = scope.getQualifier();
        ControllerContext context = this.controller.getContext(qualifier, null);
        if (context != null) {
            DictionaryFactory factory = null;
            for (DictionaryFactory df : this.factories) {
                Class contextType = df.getContextType();
                if (!contextType.isInstance(context)) continue;
                factory = df;
                break;
            }
            if (factory != null) {
                Dictionary<String, Object> dictionary = factory.getDictionary(context);
                loader.addMetaData(dictionary, Dictionary.class);
            }
        }
        return loader;
    }

    public boolean addFactory(DictionaryFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null factory");
        }
        if (factory.getContextType() == null) {
            throw new IllegalArgumentException("Null context type on factory: " + factory);
        }
        return this.factories.add(factory);
    }

    public boolean removeFactory(DictionaryFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null factory");
        }
        return this.factories.remove(factory);
    }
}

