/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.osgi.framework.bundle.DictionaryFactory;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.util.collection.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KernelDictionaryFactory
implements DictionaryFactory<KernelControllerContext> {
    private static final String NAME = "bean.name";
    private static final String[] EMPTY = new String[0];
    private KernelConfigurator configurator;
    private final ClassInfo OBJECT;

    public KernelDictionaryFactory(KernelConfigurator configurator) {
        if (configurator == null) {
            throw new IllegalArgumentException("Null configurator");
        }
        this.configurator = configurator;
        this.OBJECT = this.getClassInfo(Object.class);
    }

    private ClassInfo getClassInfo(Class<?> clazz) {
        try {
            return this.configurator.getClassInfo(clazz);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public Class<KernelControllerContext> getContextType() {
        return KernelControllerContext.class;
    }

    @Override
    public Dictionary<String, Object> getDictionary(KernelControllerContext context) {
        return new KernelDictionary(context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KernelDictionary
    extends Dictionary<String, Object> {
        private Map<Object, Object> map;
        private KernelControllerContext context;

        private KernelDictionary(KernelControllerContext context) {
            this.context = context;
            this.map = new ConcurrentHashMap<Object, Object>(2);
            this.map.put(KernelDictionaryFactory.NAME, context.getName());
            this.map.put("objectClass", EMPTY);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Enumeration<String> keys() {
            return Iterators.toEnumeration(this.map.keySet().iterator());
        }

        @Override
        public Enumeration<Object> elements() {
            return Iterators.toEnumeration(this.map.values().iterator());
        }

        @Override
        public Object get(Object key) {
            Object value = this.map.get(key);
            if (value != EMPTY) {
                return value;
            }
            ClassInfo clazz = null;
            Object target = this.context.getTarget();
            BeanInfo info = this.context.getBeanInfo();
            if (target != null) {
                clazz = KernelDictionaryFactory.this.getClassInfo(target.getClass());
            } else if (info != null) {
                clazz = info.getClassInfo();
            }
            String[] classes = EMPTY;
            if (clazz != null) {
                HashSet<String> clazzes = new HashSet<String>();
                this.traverseClass(clazz, clazzes);
                classes = clazzes.toArray(new String[clazzes.size()]);
                this.map.put("objectClass", classes);
            }
            return classes;
        }

        @Override
        public Object put(String key, Object value) {
            return this.map.put(key, value);
        }

        @Override
        public Object remove(Object key) {
            return this.map.remove(key);
        }

        protected void traverseClass(ClassInfo clazz, Set<String> classes) {
            if (clazz == null || clazz == KernelDictionaryFactory.this.OBJECT) {
                return;
            }
            classes.add(clazz.getName());
            this.traverseClass(clazz.getSuperclass(), classes);
            InterfaceInfo[] interfaces = clazz.getInterfaces();
            if (interfaces != null) {
                for (InterfaceInfo intface : interfaces) {
                    this.traverseClass((ClassInfo)intface, classes);
                }
            }
        }
    }
}

