/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeLevel;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.ControllerContextHandle;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.plugins.ControllerContextPlugin;
import org.jboss.osgi.framework.util.KernelUtils;
import org.jboss.util.collection.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDRUtils {
    private static final Logger log = Logger.getLogger(MDRUtils.class);
    private static final Dictionary<String, Object> EMPTY = new EmptyDictonary<String, Object>();

    private static MetaData getMetaData(ControllerContext context, ScopeLevel level) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        MetaData metaData = context.getScopeInfo().getMetaData();
        if (level != null && metaData != null) {
            metaData = metaData.getScopeMetaData(level);
        }
        return metaData;
    }

    static Dictionary<String, Object> getProperties(ControllerContext context) {
        Dictionary properties;
        MetaData metaData = MDRUtils.getMetaData(context, CommonLevels.INSTANCE);
        if (metaData != null && (properties = (Dictionary)metaData.getMetaData(Dictionary.class)) != null) {
            return properties;
        }
        return EMPTY;
    }

    static <T> T getProperty(ControllerContext context, String key, Class<T> expectedType) {
        return MDRUtils.getProperty(context, key, expectedType, null);
    }

    static <T> T getProperty(ControllerContext context, String key, Class<T> expectedType, T defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expected type");
        }
        Dictionary<String, Object> properties = MDRUtils.getProperties(context);
        Object result = properties.get(key);
        if (result != null && !expectedType.isInstance(result)) {
            if (defaultValue == null) {
                throw new IllegalArgumentException("Illegal result type: " + result + ", expected: " + expectedType);
            }
            result = defaultValue;
        }
        if (result == null) {
            result = defaultValue;
        }
        return expectedType.cast(result);
    }

    private static Object getSource(AbstractBundleState bundleState, String className) {
        if (bundleState.getState() == 1) {
            return null;
        }
        OSGiBundleManager bundleManager = bundleState.getBundleManager();
        return bundleManager.loadClassFailsafe(bundleState, className);
    }

    private static ClassLoader getClassLoader(Object instance) {
        return instance instanceof Class ? ((Class)Class.class.cast(instance)).getClassLoader() : instance.getClass().getClassLoader();
    }

    public static boolean matchClass(ControllerContext context, String clazz) {
        String[] classes = MDRUtils.getClasses(context);
        return classes != null && Arrays.asList(classes).contains(clazz);
    }

    public static Integer getRanking(ControllerContext context) {
        return MDRUtils.getProperty(context, "service.ranking", Integer.class, 0);
    }

    public static Long getId(ControllerContext context) {
        return MDRUtils.getProperty(context, "service.id", Long.class);
    }

    public static String[] getClasses(ControllerContext context) {
        return MDRUtils.getProperty(context, "objectClass", String[].class);
    }

    public static boolean isAssignableTo(ControllerContext context, AbstractBundleState sourceBundle, AbstractBundleState targetBundle, String className) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (sourceBundle == null) {
            throw new IllegalArgumentException("Null source bundle");
        }
        if (targetBundle == null) {
            throw new IllegalArgumentException("Null target bundle");
        }
        if (className == null) {
            throw new IllegalArgumentException("Null class name");
        }
        if (sourceBundle == targetBundle) {
            return true;
        }
        if (KernelUtils.isUnregistered(context)) {
            return false;
        }
        return MDRUtils.isAssignableTo(sourceBundle, targetBundle, className);
    }

    public static boolean isAssignableTo(ControllerContext context, AbstractBundleState sourceBundle, AbstractBundleState targetBundle, String[] classNames) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (sourceBundle == null) {
            throw new IllegalArgumentException("Null source bundle");
        }
        if (targetBundle == null) {
            throw new IllegalArgumentException("Null target bundle");
        }
        if (classNames == null) {
            throw new IllegalArgumentException("Null class names");
        }
        if (sourceBundle == targetBundle) {
            return true;
        }
        if (KernelUtils.isUnregistered(context)) {
            return false;
        }
        for (String className : classNames) {
            if (MDRUtils.isAssignableTo(sourceBundle, targetBundle, className)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignableTo(AbstractBundleState sourceBundle, AbstractBundleState targetBundle, String className) {
        if (sourceBundle == null) {
            throw new IllegalArgumentException("Null source bundle");
        }
        if (className == null) {
            throw new IllegalArgumentException("Null class name");
        }
        Object source = MDRUtils.getSource(sourceBundle, className);
        if (source == null) {
            return ((Object)((Object)sourceBundle)).equals((Object)targetBundle);
        }
        Object target = MDRUtils.getSource(targetBundle, className);
        if (target == null) {
            log.debug((Object)("Cannot load '" + className + "' from: " + (Object)((Object)targetBundle)));
            return true;
        }
        boolean equals = source.equals(target);
        if (!equals) {
            ClassLoader targetLoader = MDRUtils.getClassLoader(target);
            ClassLoader sourceLoader = MDRUtils.getClassLoader(source);
            StringBuffer buffer = new StringBuffer("Cannot assign '" + className + "' comming from different exporters");
            buffer.append("\n  source: ").append(sourceLoader);
            buffer.append("\n  target: ").append(targetLoader);
            log.warn((Object)buffer.toString());
        }
        return equals;
    }

    public static boolean isAssignableTo(ControllerContext context, AbstractBundleState sourceBundle, String className) {
        if (sourceBundle == null) {
            throw new IllegalArgumentException("Null bundle state");
        }
        OSGiBundleManager manager = sourceBundle.getBundleManager();
        ControllerContextPlugin plugin = manager.getPlugin(ControllerContextPlugin.class);
        AbstractBundleState targetBundle = plugin.getBundleForContext(context);
        return MDRUtils.isAssignableTo(context, sourceBundle, targetBundle, className);
    }

    public static boolean isAssignableTo(ControllerContext context, AbstractBundleState sourceBundle) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (sourceBundle == null) {
            throw new IllegalArgumentException("Null bundle state");
        }
        OSGiBundleManager manager = sourceBundle.getBundleManager();
        ControllerContextPlugin plugin = manager.getPlugin(ControllerContextPlugin.class);
        AbstractBundleState targetBundle = plugin.getBundleForContext(context);
        if (sourceBundle == targetBundle) {
            return true;
        }
        if (KernelUtils.isUnregistered(context)) {
            return false;
        }
        String[] classes = MDRUtils.getProperty(context, "objectClass", String[].class);
        if (classes == null) {
            return false;
        }
        for (String className : classes) {
            if (MDRUtils.isAssignableTo(sourceBundle, targetBundle, className)) continue;
            return false;
        }
        return true;
    }

    public static int compareTo(ControllerContext context, Object reference) {
        int otherRanking;
        ControllerContext other;
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (reference == null) {
            throw new IllegalArgumentException("Null reference");
        }
        if (reference instanceof ControllerContext) {
            other = (ControllerContext)reference;
        } else if (reference instanceof ControllerContextHandle) {
            other = ((ControllerContextHandle)reference).getContext();
        } else {
            throw new IllegalArgumentException(reference + " is not a service reference");
        }
        Long thisServiceId = MDRUtils.getId(context);
        Long otherServiceId = MDRUtils.getId(other);
        if (thisServiceId == null && otherServiceId == null) {
            return 0;
        }
        if (otherServiceId == null) {
            return -1;
        }
        if (thisServiceId == null) {
            return 1;
        }
        if (thisServiceId - otherServiceId == 0L) {
            return 0;
        }
        int thisRanking = MDRUtils.getRanking(context);
        int ranking = thisRanking - (otherRanking = MDRUtils.getRanking(other).intValue());
        if (ranking != 0) {
            return ranking;
        }
        return thisServiceId > otherServiceId ? -1 : 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyDictonary<K, V>
    extends Dictionary<K, V> {
        private EmptyDictonary() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Enumeration<K> keys() {
            return Iterators.toEnumeration(Collections.emptySet().iterator());
        }

        @Override
        public Enumeration<V> elements() {
            return Iterators.toEnumeration(Collections.emptySet().iterator());
        }

        @Override
        public V get(Object key) {
            return null;
        }

        @Override
        public V put(K key, V value) {
            return null;
        }

        @Override
        public V remove(Object key) {
            return null;
        }
    }
}

