/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.File;
import java.io.InputStream;
import java.util.Dictionary;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class OSGiBundleContextWrapper
implements BundleContext {
    private AbstractBundleState bundleState;
    private String canonicalName;

    public OSGiBundleContextWrapper(AbstractBundleState bundleState) {
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundle state");
        }
        this.bundleState = bundleState;
        this.canonicalName = bundleState.getCanonicalName();
    }

    void destroyBundleContext() {
        this.bundleState = null;
    }

    public void addBundleListener(BundleListener listener) {
        this.checkValidBundleContext();
        this.bundleState.addBundleListener(listener);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.checkValidBundleContext();
        this.bundleState.addFrameworkListener(listener);
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        this.bundleState.addServiceListener(listener, filter);
    }

    public void addServiceListener(ServiceListener listener) {
        this.checkValidBundleContext();
        this.bundleState.addServiceListener(listener);
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        return this.bundleState.createFilter(filter);
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        return this.bundleState.getAllServiceReferences(clazz, filter);
    }

    public Bundle getBundle() {
        this.checkValidBundleContext();
        return this.bundleState.getBundle();
    }

    public Bundle getBundle(long id) {
        this.checkValidBundleContext();
        return this.bundleState.getBundle(id);
    }

    public Bundle[] getBundles() {
        this.checkValidBundleContext();
        return this.bundleState.getBundles();
    }

    public File getDataFile(String filename) {
        this.checkValidBundleContext();
        return this.bundleState.getDataFile(filename);
    }

    public String getProperty(String key) {
        this.checkValidBundleContext();
        return this.bundleState.getProperty(key);
    }

    public Object getService(ServiceReference reference) {
        this.checkValidBundleContext();
        return this.bundleState.getService(reference);
    }

    public ServiceReference getServiceReference(String clazz) {
        this.checkValidBundleContext();
        return this.bundleState.getServiceReference(clazz);
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        return this.bundleState.getServiceReferences(clazz, filter);
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        this.checkValidBundleContext();
        return this.bundleState.installBundle(location, input);
    }

    public Bundle installBundle(String location) throws BundleException {
        this.checkValidBundleContext();
        return this.bundleState.installBundle(location);
    }

    public Bundle install(VirtualFile root) throws BundleException {
        this.checkValidBundleContext();
        return this.bundleState.installBundle(root);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        this.checkValidBundleContext();
        return this.bundleState.registerService(clazz, service, properties);
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        this.checkValidBundleContext();
        return this.bundleState.registerService(clazzes, service, properties);
    }

    public void removeBundleListener(BundleListener listener) {
        this.checkValidBundleContext();
        this.bundleState.removeBundleListener(listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.checkValidBundleContext();
        this.bundleState.removeFrameworkListener(listener);
    }

    public void removeServiceListener(ServiceListener listener) {
        this.checkValidBundleContext();
        this.bundleState.removeServiceListener(listener);
    }

    public boolean ungetService(ServiceReference reference) {
        this.checkValidBundleContext();
        return this.bundleState.ungetService(reference);
    }

    public String toString() {
        return this.canonicalName;
    }

    protected synchronized void checkValidBundleContext() {
        if (this.bundleState == null) {
            throw new IllegalStateException("Invalid bundle context: " + this.canonicalName);
        }
    }
}

