/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.launch;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.dependency.plugins.AbstractControllerContext;
import org.jboss.dependency.plugins.AbstractControllerContextActions;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.launch.OSGiFramework;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class OSGiFrameworkFactory
implements FrameworkFactory {
    public static final String BOOTSTRAP_URL = "org.jboss.osgi.framework.launch.bootstrapURL";
    public static final String BOOTSTRAP_PATH = "org.jboss.osgi.framework.launch.bootstrapPath";

    public Framework newFramework(Map configuration) {
        BasicBootstrap bootstrap = new BasicBootstrap();
        bootstrap.run();
        Kernel kernel = bootstrap.getKernel();
        KernelController controller = this.preinstallKernelBeans(kernel);
        BasicXMLDeployer deployer = new BasicXMLDeployer(kernel, ControllerMode.AUTOMATIC);
        URL url = null;
        String bootstrapURL = this.getProperty(BOOTSTRAP_URL);
        if (bootstrapURL != null) {
            try {
                url = new URL(bootstrapURL);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Invalid system property org.jboss.osgi.framework.launch.bootstrapURL", e);
            }
        }
        List<String> bootstraps = Arrays.asList("jboss-osgi-bootstrap.xml", "bootstrap/jboss-osgi-bootstrap.xml", "META-INF/jboss-osgi-bootstrap.xml", "META-INF/jboss-osgi-default-bootstrap.xml");
        String bootstrapPath = this.getProperty(BOOTSTRAP_PATH);
        if (bootstrapPath != null) {
            bootstraps = Collections.singletonList(bootstrapPath);
        }
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        for (String xml : bootstraps) {
            if (contextLoader != null) {
                url = contextLoader.getResource(xml);
            }
            if (url == null) {
                url = this.getClass().getResource(xml);
            }
            if (url == null) continue;
            break;
        }
        if (url == null) {
            throw new IllegalStateException("Cannot find any bootstrap: " + Arrays.asList(bootstraps));
        }
        try {
            deployer.deploy(url);
            deployer.validate();
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Cannot deploy bootstrap beans", ex);
        }
        ControllerContext managerContext = controller.getInstalledContext((Object)"OSGiBundleManager");
        if (managerContext == null) {
            throw new IllegalStateException("Cannot obtain installed bean: OSGiBundleManager");
        }
        OSGiBundleManager manager = (OSGiBundleManager)managerContext.getTarget();
        if (configuration != null) {
            manager.setProperties(configuration);
        }
        return new OSGiFramework(manager);
    }

    private KernelController preinstallKernelBeans(Kernel kernel) {
        KernelController controller = kernel.getController();
        AbstractControllerContextActions actions = new AbstractControllerContextActions(new HashMap());
        try {
            controller.install((ControllerContext)new AbstractControllerContext((Object)"jboss.kernel:service=KernelController", (ControllerContextActions)actions, null, (Object)controller));
            controller.install((ControllerContext)new AbstractControllerContext((Object)"jboss.kernel:service=Kernel", (ControllerContextActions)actions, null, (Object)kernel));
        }
        catch (Throwable th) {
            throw new IllegalStateException("Cannot preinstall kernel bean", th);
        }
        return controller;
    }

    private String getProperty(final String propertyName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getProperty(propertyName);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName);
            }
        });
    }
}

