/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.resolver.internal;

import java.util.Map;
import java.util.Set;
import org.jboss.osgi.framework.metadata.Parameter;
import org.jboss.osgi.framework.metadata.ParameterizedAttribute;
import org.jboss.osgi.framework.resolver.NamedElement;
import org.jboss.osgi.framework.resolver.ResolverBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class NamedElementImpl
implements NamedElement {
    private ResolverBundle owner;
    private ParameterizedAttribute paramattr;
    private String shortString;

    public NamedElementImpl(ResolverBundle owner, ParameterizedAttribute attr) {
        if (owner == null) {
            throw new IllegalArgumentException("Null element owner");
        }
        if (attr == null) {
            throw new IllegalArgumentException("Null element attribute");
        }
        this.owner = owner;
        this.paramattr = attr;
    }

    @Override
    public ResolverBundle getOwner() {
        return this.owner;
    }

    @Override
    public String getName() {
        return this.paramattr.getAttribute();
    }

    protected ParameterizedAttribute getParameterizedAttribute() {
        return this.paramattr;
    }

    @Override
    public Set<String> getAttributes() {
        return this.getParameterizedAttribute().getAttributes().keySet();
    }

    @Override
    public Object getAttribute(String key) {
        Parameter attr = this.getParameterizedAttribute().getAttribute(key);
        return attr != null ? attr.getValue() : null;
    }

    public String toShortString() {
        if (this.shortString == null) {
            Map attributes = this.getParameterizedAttribute().getAttributes();
            Map directives = this.getParameterizedAttribute().getDirectives();
            StringBuffer buffer = new StringBuffer("[" + this.getName());
            for (Map.Entry entry : directives.entrySet()) {
                buffer.append(";" + (String)entry.getKey() + ":=" + ((Parameter)entry.getValue()).getValue());
            }
            for (Map.Entry entry : attributes.entrySet()) {
                buffer.append(";" + (String)entry.getKey() + "=" + ((Parameter)entry.getValue()).getValue());
            }
            buffer.append("]");
            this.shortString = buffer.toString();
        }
        return this.shortString;
    }
}

