/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.resolver.internal;

import java.util.List;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.PackageAttribute;
import org.jboss.osgi.framework.metadata.ParameterizedAttribute;
import org.jboss.osgi.framework.resolver.internal.AbstractResolverBundle;
import org.jboss.osgi.framework.resolver.internal.ExportPackageImpl;
import org.jboss.osgi.framework.resolver.internal.ImportPackageImpl;
import org.jboss.osgi.framework.resolver.internal.RequiredBundleImpl;
import org.osgi.framework.Bundle;

public class ResolverBundleImpl
extends AbstractResolverBundle {
    private OSGiMetaData osgiMetaData;

    public ResolverBundleImpl(Bundle bundle) {
        super(bundle);
        List requireBundles;
        List importPackages;
        this.osgiMetaData = OSGiBundleState.assertBundleState(bundle).getOSGiMetaData();
        List exportPackages = this.osgiMetaData.getExportPackages();
        if (exportPackages != null) {
            for (PackageAttribute attr : exportPackages) {
                String packageName = attr.getAttribute();
                this.exportedPackages.put(packageName, new ExportPackageImpl(this, (ParameterizedAttribute)attr));
            }
        }
        if ((importPackages = this.osgiMetaData.getImportPackages()) != null) {
            for (PackageAttribute attr : importPackages) {
                String packageName = attr.getAttribute();
                this.importedPackages.put(packageName, new ImportPackageImpl(this, (ParameterizedAttribute)attr));
            }
        }
        if ((requireBundles = this.osgiMetaData.getRequireBundles()) != null) {
            for (ParameterizedAttribute attr : requireBundles) {
                String symbolicName = attr.getAttribute();
                RequiredBundleImpl req = new RequiredBundleImpl(this, attr);
                this.requiredBundles.put(symbolicName, req);
            }
        }
    }

    public boolean isSingleton() {
        return this.osgiMetaData.isSingleton();
    }
}

