/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.service.internal;

import java.util.Set;
import org.jboss.osgi.deployment.interceptor.AbstractLifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.plugins.internal.AbstractServicePlugin;
import org.jboss.osgi.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebXMLVerifierInterceptor
extends AbstractServicePlugin
implements LifecycleInterceptor {
    private LifecycleInterceptor delegate = new AbstractLifecycleInterceptor(){

        public void invoke(int state, InvocationContext context) throws LifecycleInterceptorException {
            if (state == 8) {
                try {
                    boolean isWebApp;
                    VirtualFile root = context.getRoot();
                    VirtualFile webXML = root.getChild("/WEB-INF/web.xml");
                    String contextPath = (String)context.getBundle().getHeaders().get("Web-ContextPath");
                    boolean bl = isWebApp = contextPath != null || root.getName().endsWith(".war");
                    if (isWebApp && webXML == null) {
                        throw new LifecycleInterceptorException("Cannot obtain web.xml from: " + root.toURL());
                    }
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (Exception ex) {
                    throw new LifecycleInterceptorException("Cannot check for web.xml", (Throwable)ex);
                }
            }
        }
    };

    public WebXMLVerifierInterceptor(OSGiBundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public void startService() {
        this.getSystemContext().registerService(LifecycleInterceptor.class.getName(), (Object)this.delegate, null);
    }

    @Override
    public void stopService() {
    }

    public Set<Class<?>> getInput() {
        return this.delegate.getInput();
    }

    public Set<Class<?>> getOutput() {
        return this.delegate.getOutput();
    }

    public int getRelativeOrder() {
        return this.delegate.getRelativeOrder();
    }

    public void invoke(int state, InvocationContext context) throws LifecycleInterceptorException {
        this.delegate.invoke(state, context);
    }
}

