/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.framework;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.codec.PropertyData;
import org.apache.aries.jmx.codec.ServiceData;
import org.apache.aries.jmx.codec.ServiceEventData;
import org.apache.aries.jmx.util.FrameworkUtils;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.JmxConstants;
import org.osgi.jmx.framework.ServiceStateMBean;

public class ServiceState
extends NotificationBroadcasterSupport
implements ServiceStateMBean,
MBeanRegistration {
    protected Logger logger;
    private BundleContext bundleContext;
    protected ExecutorService eventDispatcher;
    protected AllServiceListener serviceListener;
    private AtomicInteger notificationSequenceNumber = new AtomicInteger(1);
    private AtomicInteger registrations = new AtomicInteger(0);
    private Lock lock = new ReentrantLock();
    public static String SERVICE_EVENT = "org.osgi.service.event";

    public ServiceState(BundleContext bundleContext, Logger logger) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("Argument bundleContext cannot be null");
        }
        this.bundleContext = bundleContext;
        this.logger = logger;
    }

    public long getBundleIdentifier(long serviceId) throws IOException, IllegalArgumentException {
        ServiceReference reference = FrameworkUtils.resolveService(this.bundleContext, serviceId);
        return reference.getBundle().getBundleId();
    }

    public String[] getObjectClass(long serviceId) throws IOException {
        ServiceReference reference = FrameworkUtils.resolveService(this.bundleContext, serviceId);
        return (String[])reference.getProperty("objectClass");
    }

    public TabularData getProperties(long serviceId) throws IOException {
        ServiceReference reference = FrameworkUtils.resolveService(this.bundleContext, serviceId);
        TabularDataSupport propertiesTable = new TabularDataSupport(JmxConstants.PROPERTIES_TYPE);
        for (String propertyKey : reference.getPropertyKeys()) {
            propertiesTable.put(PropertyData.newInstance(propertyKey, reference.getProperty(propertyKey)).toCompositeData());
        }
        return propertiesTable;
    }

    public long[] getUsingBundles(long serviceId) throws IOException {
        ServiceReference reference = FrameworkUtils.resolveService(this.bundleContext, serviceId);
        Bundle[] usingBundles = reference.getUsingBundles();
        return FrameworkUtils.getBundleIds(usingBundles);
    }

    public TabularData listServices() throws IOException {
        TabularDataSupport servicesTable = new TabularDataSupport(SERVICES_TYPE);
        ServiceReference[] allServiceReferences = null;
        try {
            allServiceReferences = this.bundleContext.getAllServiceReferences(null, null);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Failed to retrieve all service references", e);
        }
        if (allServiceReferences != null) {
            for (ServiceReference reference : allServiceReferences) {
                servicesTable.put(new ServiceData(reference).toCompositeData());
            }
        }
        return servicesTable;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{SERVICE_EVENT};
        String name = Notification.class.getName();
        String description = "A ServiceEvent issued from the Framework describing a service lifecycle change";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, name, description);
        return new MBeanNotificationInfo[]{info};
    }

    public void postDeregister() {
        if (this.registrations.decrementAndGet() < 1) {
            this.shutDownDispatcher();
        }
    }

    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue() && this.registrations.incrementAndGet() == 1) {
            this.eventDispatcher = Executors.newSingleThreadExecutor();
            this.bundleContext.addServiceListener((ServiceListener)this.serviceListener);
        }
    }

    public void preDeregister() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.lock.lock();
        try {
            if (this.serviceListener == null) {
                this.serviceListener = new AllServiceListener(){

                    public void serviceChanged(ServiceEvent serviceevent) {
                        final Notification notification = new Notification("ServiceEvent", "osgi.core:type=serviceState,version=1.5", ServiceState.this.notificationSequenceNumber.getAndIncrement());
                        try {
                            notification.setUserData(new ServiceEventData(serviceevent).toCompositeData());
                            ServiceState.this.eventDispatcher.submit(new Runnable(){

                                public void run() {
                                    ServiceState.this.sendNotification(notification);
                                }
                            });
                        }
                        catch (RejectedExecutionException re) {
                            ServiceState.this.logger.log(2, "Task rejected for JMX Notification dispatch of event [" + serviceevent + "] - Dispatcher may have been shutdown");
                        }
                        catch (Exception e) {
                            ServiceState.this.logger.log(2, "Exception occured on JMX Notification dispatch for event [" + serviceevent + "]", e);
                        }
                    }
                };
            }
        }
        finally {
            this.lock.unlock();
        }
        return name;
    }

    protected void shutDownDispatcher() {
        if (this.serviceListener != null) {
            try {
                this.bundleContext.removeServiceListener((ServiceListener)this.serviceListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.shutdown();
        }
    }

    protected ExecutorService getEventDispatcher() {
        return this.eventDispatcher;
    }
}

