/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.core.BundleUtils;
import org.ops4j.pax.swissbox.tracker.ReplaceableService;
import org.ops4j.pax.swissbox.tracker.ReplaceableServiceListener;
import org.ops4j.pax.web.extender.war.internal.RegisterWebAppVisitorHS;
import org.ops4j.pax.web.extender.war.internal.RegisterWebAppVisitorWC;
import org.ops4j.pax.web.extender.war.internal.UnregisterWebAppVisitorHS;
import org.ops4j.pax.web.extender.war.internal.UnregisterWebAppVisitorWC;
import org.ops4j.pax.web.extender.war.internal.WebAppVisitor;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.util.WebContainerUtils;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpService;

class WebAppPublisher {
    private static final Log LOG = LogFactory.getLog(WebAppPublisher.class);
    private final Map<WebApp, ReplaceableService<HttpService>> m_webApps = Collections.synchronizedMap(new HashMap());

    WebAppPublisher() {
    }

    public void publish(WebApp webApp) {
        NullArgumentException.validateNotNull((Object)webApp, (String)"Web app");
        LOG.debug((Object)("Publishing web application [" + webApp + "]"));
        BundleContext bundleContext = BundleUtils.getBundleContext((Bundle)webApp.getBundle());
        if (bundleContext != null) {
            ReplaceableService httpServiceTracker = new ReplaceableService(bundleContext, HttpService.class, (ReplaceableServiceListener)new HttpServiceListener(webApp));
            httpServiceTracker.start();
            this.m_webApps.put(webApp, (ReplaceableService<HttpService>)httpServiceTracker);
        } else {
            LOG.warn((Object)("Bundle context could not be discovered for bundle [" + webApp.getBundle() + "]" + "Skipping publishing of web application [" + webApp + "]"));
        }
    }

    public void unpublish(WebApp webApp) {
        NullArgumentException.validateNotNull((Object)webApp, (String)"Web app");
        LOG.debug((Object)("Unpublishing web application [" + webApp + "]"));
        ReplaceableService<HttpService> httpServiceTracker = this.m_webApps.get(webApp);
        if (httpServiceTracker != null) {
            this.m_webApps.remove(webApp);
            if (32 == webApp.getBundle().getState()) {
                httpServiceTracker.stop();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HttpServiceListener
    implements ReplaceableServiceListener<HttpService> {
        private final WebApp m_webApp;
        private HttpService m_httpService;

        HttpServiceListener(WebApp webApp) {
            NullArgumentException.validateNotNull((Object)webApp, (String)"Web app");
            this.m_webApp = webApp;
        }

        public synchronized void serviceChanged(HttpService oldHttpService, HttpService newHttpService) {
            this.unregister();
            this.m_httpService = newHttpService;
            this.register();
        }

        private void register() {
            if (this.m_httpService != null) {
                LOG.debug((Object)("Registering web application [" + this.m_webApp + "] from http service [" + this.m_httpService + "]"));
                if (WebContainerUtils.webContainerAvailable((HttpService)this.m_httpService)) {
                    this.m_webApp.accept((WebAppVisitor)new RegisterWebAppVisitorWC((WebContainer)this.m_httpService));
                } else {
                    this.m_webApp.accept((WebAppVisitor)new RegisterWebAppVisitorHS(this.m_httpService));
                }
            }
        }

        private void unregister() {
            if (this.m_httpService != null) {
                LOG.debug((Object)("Unregistering web application [" + this.m_webApp + "] from http service [" + this.m_httpService + "]"));
                if (WebContainerUtils.webContainerAvailable((HttpService)this.m_httpService)) {
                    this.m_webApp.accept((WebAppVisitor)new UnregisterWebAppVisitorWC((WebContainer)this.m_httpService));
                } else {
                    this.m_webApp.accept((WebAppVisitor)new UnregisterWebAppVisitorHS(this.m_httpService));
                }
            }
        }
    }
}

