/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jndi.internal;

import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.naming.NamingContextFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class InitialContextFactory
implements ServiceFactory {
    private String jndiHost;
    private String jndiPort;

    public InitialContextFactory(String jndiHost, String jndiPort) {
        this.jndiHost = jndiHost;
        this.jndiPort = jndiPort;
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        try {
            return this.getInitialContext(bundle);
        }
        catch (NamingException ex) {
            throw new IllegalStateException("Cannot get the InitialContext", ex);
        }
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InitialContext getInitialContext(Bundle bundle) throws NamingException {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            InitialContext iniCtx;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", NamingContextFactory.class.getName());
            env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            env.put("java.naming.provider.url", "jnp://" + this.jndiHost + ":" + this.jndiPort);
            InitialContext initialContext = iniCtx = new InitialContext(env);
            return initialContext;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
    }
}

