/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jndi.internal;

import java.io.IOException;
import java.net.Socket;
import javax.naming.InitialContext;
import org.jboss.osgi.jndi.internal.InitialContextFactory;
import org.jboss.osgi.jndi.internal.JNPServer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class JNDIServiceActivator
implements BundleActivator {
    private ServiceRegistration registration;
    private JNPServer jnpServer;

    public void start(BundleContext context) {
        String jndiPort;
        String jndiRmiPort;
        String jndiHost = context.getProperty("org.jboss.osgi.jndi.host");
        if (jndiHost == null) {
            jndiHost = "localhost";
        }
        if ((jndiRmiPort = context.getProperty("org.jboss.osgi.jndi.rmi.port")) == null) {
            jndiRmiPort = "1098";
        }
        if ((jndiPort = context.getProperty("org.jboss.osgi.jndi.port")) == null) {
            jndiPort = "1099";
        }
        try {
            Socket socket = new Socket(jndiHost, Integer.parseInt(jndiPort));
            socket.close();
        }
        catch (IOException ex) {
            this.jnpServer = new JNPServer(context, jndiHost, Integer.parseInt(jndiPort), Integer.parseInt(jndiRmiPort));
            this.jnpServer.start();
        }
        InitialContextFactory serviceFactory = new InitialContextFactory(jndiHost, jndiPort);
        this.registration = context.registerService(InitialContext.class.getName(), (Object)serviceFactory, null);
    }

    public void stop(BundleContext context) {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        if (this.jnpServer != null) {
            this.jnpServer.stop();
            this.jnpServer = null;
        }
    }
}

