/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jbossxb.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.jboss.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class XMLBindingDocumentBuilderFactory
extends DocumentBuilderFactory {
    private static Logger log;
    private static BundleContext context;
    private Map<String, Boolean> features = new HashMap<String, Boolean>();
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public static void setBundleContext(BundleContext context) {
        log = Logger.getLogger(XMLBindingDocumentBuilderFactory.class);
        XMLBindingDocumentBuilderFactory.context = context;
    }

    public boolean getFeature(String name) {
        Boolean value = this.features.get(name);
        return value != null ? value : false;
    }

    public void setFeature(String name, boolean value) {
        this.features.put(name, new Boolean(value));
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        String validating = "(parser.validating=" + this.isValidating() + ")";
        String namespaceAware = "(parser.namespaceAware=" + this.isNamespaceAware() + ")";
        String filter = "(&" + validating + namespaceAware + ")";
        DocumentBuilderFactory factory = null;
        if (context != null) {
            try {
                ServiceReference[] srefs = context.getServiceReferences(DocumentBuilderFactory.class.getName(), filter);
                if (srefs != null) {
                    if (srefs.length > 1) {
                        this.logDebug("Multiple DocumentBuilderFactory services: " + Arrays.asList(srefs));
                    }
                    this.logDebug("Using DocumentBuilderFactory service: " + srefs[0]);
                    factory = (DocumentBuilderFactory)context.getService(srefs[0]);
                }
            }
            catch (InvalidSyntaxException ex) {
                // empty catch block
            }
        }
        if (factory == null) {
            this.logDebug("Cannot obtain DocumentBuilderFactory service " + filter + ". Now use " + DocumentBuilderFactoryImpl.class.getName());
            factory = new DocumentBuilderFactoryImpl();
        }
        for (Map.Entry<String, Boolean> entry : this.features.entrySet()) {
            this.logDebug("Set feature [" + entry.getKey() + "=" + entry.getValue() + "]");
            factory.setFeature(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            this.logDebug("Set attribute [" + entry.getKey() + "=" + entry.getValue() + "]");
            factory.setAttribute(entry.getKey(), entry.getValue());
        }
        return factory.newDocumentBuilder();
    }

    private void logDebug(String message) {
        if (log != null) {
            log.debug((Object)message);
        }
    }
}

