/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jbossxb.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.jboss.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.xml.sax.SAXException;

public class XMLBindingSAXParserFactory
extends SAXParserFactory {
    private static Logger log;
    private static BundleContext context;
    private Map<String, Boolean> features = new HashMap<String, Boolean>();

    public static void setBundleContext(BundleContext context) {
        log = Logger.getLogger(XMLBindingSAXParserFactory.class);
        XMLBindingSAXParserFactory.context = context;
    }

    public boolean getFeature(String name) {
        Boolean value = this.features.get(name);
        return value != null ? value : false;
    }

    public void setFeature(String name, boolean value) {
        this.features.put(name, new Boolean(value));
    }

    public SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        String validating = "(parser.validating=" + this.isValidating() + ")";
        String namespaceAware = "(parser.namespaceAware=" + this.isNamespaceAware() + ")";
        String filter = "(&" + validating + namespaceAware + ")";
        SAXParserFactory factory = null;
        if (context != null) {
            try {
                ServiceReference[] srefs = context.getServiceReferences(SAXParserFactory.class.getName(), filter);
                if (srefs != null) {
                    if (srefs.length > 1) {
                        this.logDebug("Multiple SAXParserFactory services: " + Arrays.asList(srefs));
                    }
                    this.logDebug("Using SAXParserFactory service: " + srefs[0]);
                    factory = (SAXParserFactory)context.getService(srefs[0]);
                }
            }
            catch (InvalidSyntaxException ex) {
                // empty catch block
            }
        }
        if (factory == null) {
            this.logDebug("Cannot obtain SAXParserFactory service " + filter + ". Now use " + SAXParserFactoryImpl.class.getName());
            factory = new SAXParserFactoryImpl();
        }
        for (Map.Entry<String, Boolean> entry : this.features.entrySet()) {
            this.logDebug("Set feature [" + entry.getKey() + "=" + entry.getValue() + "]");
            factory.setFeature(entry.getKey(), entry.getValue());
        }
        return factory.newSAXParser();
    }

    private void logDebug(String message) {
        if (log != null) {
            log.debug((Object)message);
        }
    }
}

