/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.spi.util.ExportedPackageHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleStartStopDeployer
extends AbstractSimpleRealDeployer<Bundle> {
    private BundleContext systemContext;
    private PackageAdmin packageAdmin;
    private List<Bundle> unresolvedBundles = new ArrayList<Bundle>();

    public BundleStartStopDeployer() {
        super(Bundle.class);
        this.addInput(Deployment.class);
    }

    public void setSystemContext(BundleContext systemContext) {
        this.systemContext = systemContext;
    }

    public void deploy(DeploymentUnit unit, Bundle bundle) throws DeploymentException {
        boolean autoStart;
        Deployment dep = (Deployment)unit.getAttachment(Deployment.class);
        boolean bl = autoStart = dep != null ? dep.isAutoStart() : true;
        if (autoStart) {
            String propDeferredStart = this.systemContext.getProperty("org.jboss.osgi.deferred.start");
            if (Boolean.parseBoolean(propDeferredStart != null ? propDeferredStart : "true")) {
                this.deferredStart(unit, bundle);
            } else {
                this.simpleStart(unit, bundle);
            }
        }
    }

    public void undeploy(DeploymentUnit unit, Bundle bundle) {
        try {
            bundle.stop();
            this.unresolvedBundles.remove(bundle);
            this.log.info((Object)("Stoped: " + bundle));
        }
        catch (BundleException e) {
            this.log.warn((Object)("Cannot stop bundle: " + (Object)((Object)e)));
        }
    }

    private void simpleStart(DeploymentUnit unit, Bundle bundle) throws DeploymentException {
        ExportedPackageHelper packageHelper = new ExportedPackageHelper(this.systemContext);
        try {
            bundle.start();
            this.log.info((Object)("Started: " + bundle));
            packageHelper.logExportedPackages(bundle);
        }
        catch (BundleException e) {
            this.log.warn((Object)"Cannot start bundle", (Throwable)e);
        }
    }

    private void deferredStart(DeploymentUnit unit, Bundle bundle) throws DeploymentException {
        ExportedPackageHelper packageHelper = new ExportedPackageHelper(this.systemContext);
        if (this.packageAdmin == null) {
            ServiceReference sref = this.systemContext.getServiceReference(PackageAdmin.class.getName());
            this.packageAdmin = (PackageAdmin)this.systemContext.getService(sref);
            if (this.packageAdmin == null) {
                throw new IllegalStateException("Cannot obtain PackageAdmin service");
            }
        }
        this.unresolvedBundles.add(bundle);
        Bundle[] bundleArr = new Bundle[this.unresolvedBundles.size()];
        this.unresolvedBundles.toArray(bundleArr);
        this.packageAdmin.resolveBundles(bundleArr);
        Iterator<Bundle> it = this.unresolvedBundles.iterator();
        while (it.hasNext()) {
            Bundle auxBundle = it.next();
            if ((4 & auxBundle.getState()) != 4) continue;
            it.remove();
            try {
                auxBundle.start();
                packageHelper.logExportedPackages(bundle);
                this.log.info((Object)("Started: " + bundle));
            }
            catch (BundleException e) {
                this.log.warn((Object)"Cannot start bundle", (Throwable)e);
            }
        }
        if (this.unresolvedBundles.size() > 0) {
            this.log.info((Object)("Unresolved: " + this.unresolvedBundles));
        }
    }
}

