/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.husky.internal;

import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import org.jboss.logging.Logger;
import org.jboss.osgi.husky.Invoker;
import org.jboss.osgi.husky.Request;
import org.jboss.osgi.husky.Response;
import org.jboss.osgi.husky.internal.JMXInvocation;
import org.jboss.osgi.husky.internal.SocketInvocation;

public class AbstractInvoker
implements Invoker {
    private static final Logger log = Logger.getLogger(AbstractInvoker.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response invoke(Request req) {
        Response response;
        log.debug((Object)("Start invoke: " + req));
        Response res = null;
        try {
            MBeanServerConnection server = this.getMBeanServer();
            res = SocketInvocation.isRemoteConnection() ? new SocketInvocation().invoke(req) : new JMXInvocation().invoke(server, req);
            response = res;
        }
        catch (RuntimeException rte) {
            try {
                throw rte;
                catch (Exception ex) {
                    throw new IllegalStateException("Cannot invoke connector", ex);
                }
            }
            catch (Throwable throwable) {
                log.debug((Object)("End invoke: " + res));
                throw throwable;
            }
        }
        log.debug((Object)("End invoke: " + res));
        return response;
    }

    private MBeanServerConnection getMBeanServer() {
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            throw new IllegalStateException("Multiple MBeanServer instances not supported");
        }
        MBeanServer server = null;
        if (serverArr.size() == 1) {
            server = serverArr.get(0);
        }
        if (server == null) {
            server = MBeanServerFactory.createMBeanServer();
        }
        return server;
    }
}

