/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.util.Path;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultHttpContext
implements WebContainerContext {
    private static final Log LOG = LogFactory.getLog(DefaultHttpContext.class);
    private final Bundle m_bundle;

    DefaultHttpContext(Bundle bundle) {
        NullArgumentException.validateNotNull(bundle, "Bundle");
        this.m_bundle = bundle;
    }

    @Override
    public boolean handleSecurity(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return true;
    }

    @Override
    public URL getResource(String name) {
        String normalizedname = Path.normalizeResourcePath(name);
        LOG.debug("Searching bundle [" + this.m_bundle + "] for resource [" + normalizedname + "]");
        return this.m_bundle.getResource(normalizedname);
    }

    @Override
    public String getMimeType(String name) {
        return null;
    }

    @Override
    public Set<String> getResourcePaths(String name) {
        String normalizedname = Path.normalizeResourcePath(name);
        LOG.debug("Searching bundle [" + this.m_bundle + "] for resource paths of [" + normalizedname + "]");
        Enumeration entryPaths = this.m_bundle.getEntryPaths(normalizedname);
        if (entryPaths == null || !entryPaths.hasMoreElements()) {
            return null;
        }
        HashSet<String> foundPaths = new HashSet<String>();
        while (entryPaths.hasMoreElements()) {
            foundPaths.add((String)entryPaths.nextElement());
        }
        return foundPaths;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "bundle=" + this.m_bundle + "}";
    }
}

