/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.dependency.plugins.tracker.AbstractContextTracker;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.tracker.ContextTracker;
import org.jboss.dependency.spi.tracker.ContextTracking;
import org.jboss.osgi.framework.bundle.OSGiBundleContextWrapper;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiBundleWrapper;
import org.jboss.osgi.framework.bundle.OSGiServiceState;
import org.jboss.osgi.framework.metadata.CaseInsensitiveDictionary;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.plugins.BundleStoragePlugin;
import org.jboss.osgi.framework.plugins.FrameworkEventsPlugin;
import org.jboss.osgi.framework.plugins.LifecycleInterceptorServicePlugin;
import org.jboss.osgi.framework.plugins.Plugin;
import org.jboss.osgi.framework.plugins.ServiceManagerPlugin;
import org.jboss.osgi.spi.NotImplementedException;
import org.jboss.osgi.spi.util.ConstantsHelper;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

public abstract class AbstractBundleState
extends AbstractContextTracker
implements Bundle,
BundleContext {
    private long lastModified = System.currentTimeMillis();
    private OSGiBundleManager bundleManager;
    private BundleContext bundleContext;
    private Bundle bundle;
    private String symbolicName;
    private AtomicInteger state = new AtomicInteger(1);
    protected boolean persistentlyStarted = false;

    public AbstractBundleState(OSGiBundleManager bundleManager) {
        if (bundleManager == null) {
            throw new IllegalArgumentException("Null bundle manager");
        }
        this.bundleManager = bundleManager;
    }

    public static AbstractBundleState assertBundleState(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        if (bundle instanceof OSGiBundleWrapper) {
            bundle = ((OSGiBundleWrapper)bundle).getBundleState();
        }
        if (!(bundle instanceof AbstractBundleState)) {
            throw new IllegalArgumentException("Not an AbstractBundleState: " + bundle);
        }
        return (AbstractBundleState)bundle;
    }

    public OSGiBundleManager getBundleManager() {
        return this.bundleManager;
    }

    public String getSymbolicName() {
        if (this.symbolicName == null) {
            this.symbolicName = this.getOSGiMetaData().getBundleSymbolicName();
        }
        return this.symbolicName;
    }

    public int getState() {
        return this.state.get();
    }

    public abstract boolean isPersistentlyStarted();

    public abstract boolean isFragment();

    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
        throw new NotImplementedException();
    }

    public BundleContext getBundleContext() {
        this.checkAdminPermission("context");
        return this.bundleContext;
    }

    synchronized BundleContext createBundleContext() {
        if (this.bundleContext == null) {
            this.bundleContext = new OSGiBundleContextWrapper(this);
        }
        return this.bundleContext;
    }

    synchronized void destroyBundleContext() {
        if (this.bundleContext != null) {
            ((OSGiBundleContextWrapper)this.bundleContext).destroyBundleContext();
        }
        this.bundleContext = null;
    }

    public Bundle getBundle() {
        this.checkValidBundleContext();
        return this.getBundleInternal();
    }

    public synchronized Bundle getBundleInternal() {
        if (this.bundle == null) {
            this.bundle = new OSGiBundleWrapper(this);
        }
        return this.bundle;
    }

    public Bundle getBundle(long id) {
        this.checkValidBundleContext();
        AbstractBundleState bundleState = this.getBundleManager().getBundleById(id);
        return bundleState != null ? bundleState.getBundleInternal() : null;
    }

    public Bundle[] getBundles() {
        this.checkValidBundleContext();
        Collection<AbstractBundleState> bundleStates = this.getBundleManager().getBundles();
        if (bundleStates.isEmpty()) {
            return new Bundle[0];
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>(bundleStates.size());
        for (AbstractBundleState bundleState : bundleStates) {
            bundles.add(bundleState.getBundleInternal());
        }
        return bundles.toArray(new Bundle[bundles.size()]);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    void updateLastModified() {
        this.lastModified = System.currentTimeMillis();
    }

    public abstract OSGiMetaData getOSGiMetaData();

    public void update() throws BundleException {
        this.update(null);
    }

    public Dictionary<String, String> getHeaders() {
        return this.getHeaders(null);
    }

    public Dictionary<String, String> getHeaders(String locale) {
        URL entryURL;
        String baseName;
        this.checkAdminPermission("metadata");
        Dictionary rawHeaders = this.getOSGiMetaData().getHeaders();
        if ("".equals(locale)) {
            return rawHeaders;
        }
        if (locale == null) {
            locale = Locale.getDefault().toString();
        }
        if ((baseName = (String)rawHeaders.get("Bundle-Localization")) == null) {
            baseName = "OSGI-INF/l10n/bundle";
        }
        if ((entryURL = this.getLocalizationEntry(baseName, locale)) == null) {
            String defaultLocale = Locale.getDefault().toString();
            entryURL = this.getLocalizationEntry(baseName, defaultLocale);
        }
        PropertyResourceBundle resBundle = null;
        if (entryURL != null) {
            try {
                resBundle = new PropertyResourceBundle(entryURL.openStream());
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot read resouce bundle: " + entryURL, ex);
            }
        }
        Hashtable<String, String> locHeaders = new Hashtable<String, String>();
        Enumeration e = rawHeaders.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)rawHeaders.get(key);
            if (value.startsWith("%")) {
                value = value.substring(1);
            }
            if (resBundle != null) {
                try {
                    value = resBundle.getString(value);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
            }
            ((Dictionary)locHeaders).put(key, value);
        }
        return new CaseInsensitiveDictionary(locHeaders);
    }

    URL getLocalizationEntry(String baseName, String locale) {
        String entryPath = baseName + "_" + locale + ".properties";
        URL entryURL = this.getLocalizationEntry(entryPath);
        while (entryURL == null && !entryPath.equals(baseName + ".properties")) {
            int lastIndex = locale.lastIndexOf(95);
            if (lastIndex > 0) {
                locale = locale.substring(0, lastIndex);
                entryPath = baseName + "_" + locale + ".properties";
            } else {
                entryPath = baseName + ".properties";
            }
            entryURL = this.getLocalizationEntry(entryPath);
        }
        return entryURL;
    }

    URL getLocalizationEntry(String entryPath) {
        return null;
    }

    URL getEntryInternal(String path) {
        return null;
    }

    public String getProperty(String key) {
        this.checkValidBundleContext();
        return this.getBundleManager().getProperty(key);
    }

    public File getDataFile(String filename) {
        this.checkValidBundleContext();
        BundleStoragePlugin storagePlugin = this.getBundleManager().getOptionalPlugin(BundleStoragePlugin.class);
        return storagePlugin != null ? storagePlugin.getDataFile(this, filename) : null;
    }

    public boolean hasPermission(Object permission) {
        if (permission == null || !(permission instanceof Permission)) {
            return false;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return true;
        }
        return true;
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        return FrameworkUtil.createFilter((String)filter);
    }

    public void addServiceListener(ServiceListener listener) {
        try {
            this.addServiceListenerInternal(listener, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.addServiceListenerInternal(listener, filter);
    }

    public void addServiceListenerInternal(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        FrameworkEventsPlugin plugin = this.getBundleManager().getPlugin(FrameworkEventsPlugin.class);
        plugin.addServiceListener(this, listener, filter);
    }

    public void removeServiceListener(ServiceListener listener) {
        this.checkValidBundleContext();
        FrameworkEventsPlugin plugin = this.getBundleManager().getPlugin(FrameworkEventsPlugin.class);
        plugin.removeServiceListener(this, listener);
    }

    public ServiceReference[] getRegisteredServices() {
        this.checkInstalled();
        ServiceManagerPlugin plugin = this.getBundleManager().getPlugin(ServiceManagerPlugin.class);
        return plugin.getRegisteredServices(this);
    }

    boolean removeContextInUse(ControllerContext context) {
        int usedByCount = this.getUsedByCount(context, (Object)this);
        if (context instanceof ContextTracking) {
            ContextTracking ct = (ContextTracking)context;
            ct.ungetTarget((ContextTracker)this);
        }
        return usedByCount > 0;
    }

    public ServiceReference[] getServicesInUse() {
        this.checkInstalled();
        ServiceManagerPlugin plugin = this.getBundleManager().getPlugin(ServiceManagerPlugin.class);
        return plugin.getServicesInUse(this);
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        ServiceManagerPlugin plugin = this.getBundleManager().getPlugin(ServiceManagerPlugin.class);
        return plugin.getServiceReferences(this, clazz, filter, false);
    }

    public Object getService(ServiceReference reference) {
        this.checkValidBundleContext();
        ServiceManagerPlugin plugin = this.getBundleManager().getPlugin(ServiceManagerPlugin.class);
        return plugin.getService(this, reference);
    }

    public ServiceReference getServiceReference(String clazz) {
        this.checkValidBundleContext();
        ServiceManagerPlugin plugin = this.getBundleManager().getPlugin(ServiceManagerPlugin.class);
        return plugin.getServiceReference(this, clazz);
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        ServiceManagerPlugin plugin = this.getBundleManager().getPlugin(ServiceManagerPlugin.class);
        return plugin.getServiceReferences(this, clazz, filter, true);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        return this.registerService(new String[]{clazz}, service, properties);
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        this.checkValidBundleContext();
        ServiceManagerPlugin plugin = this.getBundleManager().getPlugin(ServiceManagerPlugin.class);
        OSGiServiceState serviceState = (OSGiServiceState)plugin.registerService(this, clazzes, service, properties);
        return serviceState.getRegistration();
    }

    void unregisterService(OSGiServiceState serviceState) {
        ServiceManagerPlugin plugin = this.getBundleManager().getPlugin(ServiceManagerPlugin.class);
        plugin.unregisterService(serviceState);
    }

    public boolean ungetService(ServiceReference reference) {
        this.checkValidBundleContext();
        ServiceManagerPlugin plugin = this.getBundleManager().getPlugin(ServiceManagerPlugin.class);
        return plugin.ungetService(this, reference);
    }

    boolean ungetContext(ControllerContext context) {
        return this.removeContextInUse(context);
    }

    public void addBundleListener(BundleListener listener) {
        this.checkValidBundleContext();
        if (listener instanceof SynchronousBundleListener) {
            this.checkAdminPermission("listener");
        }
        FrameworkEventsPlugin plugin = this.getBundleManager().getPlugin(FrameworkEventsPlugin.class);
        plugin.addBundleListener(this, listener);
    }

    public void removeBundleListener(BundleListener listener) {
        this.checkValidBundleContext();
        if (listener instanceof SynchronousBundleListener) {
            this.checkAdminPermission("listener");
        }
        FrameworkEventsPlugin plugin = this.getBundleManager().getPlugin(FrameworkEventsPlugin.class);
        plugin.removeBundleListener(this, listener);
    }

    public void start() throws BundleException {
        this.start(0);
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    void uninstallInternal() {
        this.changeState(1);
        FrameworkEventsPlugin plugin = this.getBundleManager().getPlugin(FrameworkEventsPlugin.class);
        plugin.removeFrameworkListeners(this);
        plugin.removeBundleListeners(this);
        plugin.removeServiceListeners(this);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.checkValidBundleContext();
        FrameworkEventsPlugin plugin = this.getBundleManager().getPlugin(FrameworkEventsPlugin.class);
        plugin.addFrameworkListener(this, listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.checkValidBundleContext();
        FrameworkEventsPlugin plugin = this.getBundleManager().getPlugin(FrameworkEventsPlugin.class);
        plugin.removeFrameworkListener(this, listener);
    }

    public Bundle installBundle(String location) throws BundleException {
        return this.installBundle(location, null);
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        this.checkValidBundleContext();
        this.checkAdminPermission("lifecycle");
        AbstractBundleState bundleState = this.getBundleManager().installBundle(location, input);
        return bundleState.getBundleInternal();
    }

    public Bundle installBundle(VirtualFile root) throws BundleException {
        this.checkValidBundleContext();
        this.checkAdminPermission("lifecycle");
        AbstractBundleState bundleState = this.getBundleManager().installBundle(root);
        return bundleState.getBundleInternal();
    }

    public String getCanonicalName() {
        return this.getSymbolicName() + "-" + this.getVersion();
    }

    public void changeState(int state) {
        this.changeState(state, true);
    }

    public void changeState(int state, boolean fireEvent) {
        Plugin plugin;
        int bundleEventType;
        int previous = this.getState();
        switch (state) {
            case 8: {
                bundleEventType = 128;
                break;
            }
            case 32: {
                bundleEventType = 2;
                break;
            }
            case 16: {
                bundleEventType = 256;
                break;
            }
            case 1: {
                bundleEventType = 16;
                break;
            }
            case 2: {
                if (previous == 4) {
                    bundleEventType = 64;
                    break;
                }
                bundleEventType = 1;
                break;
            }
            case 4: {
                if (previous == 16) {
                    bundleEventType = 4;
                    break;
                }
                bundleEventType = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown bundle state: " + state);
            }
        }
        if (this.getBundleManager().isFrameworkActive() && this.getBundleId() != 0L && (plugin = this.getBundleManager().getOptionalPlugin(LifecycleInterceptorServicePlugin.class)) != null) {
            plugin.handleStateChange(state, this.getBundleInternal());
        }
        this.state.set(state);
        this.log.debug((Object)((Object)((Object)this) + " change state=" + ConstantsHelper.bundleState((int)state)));
        if (fireEvent && this.getBundleManager().isFrameworkActive()) {
            plugin = this.getBundleManager().getPlugin(FrameworkEventsPlugin.class);
            plugin.fireBundleEvent(this, bundleEventType);
        }
    }

    protected void checkInstalled() {
        if ((this.getState() & 1) != 0) {
            throw new IllegalStateException("Bundle " + this.getCanonicalName() + " is not installed");
        }
    }

    protected synchronized void checkValidBundleContext() {
        if (this.bundleContext == null) {
            throw new IllegalStateException("Invalid bundle context: " + this.getCanonicalName());
        }
    }

    protected void checkAdminPermission(String what) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new AdminPermission((Bundle)this, what));
        }
    }

    protected boolean noAdminPermission(String what) {
        try {
            this.checkAdminPermission(what);
            return false;
        }
        catch (SecurityException e) {
            return true;
        }
    }

    public String toString() {
        return "Bundle{" + this.getCanonicalName() + "}";
    }
}

