/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.osgi.framework.bundle.DictionaryFactory;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.util.collection.Iterators;

public abstract class AbstractDictionaryFactory<T extends ControllerContext>
implements DictionaryFactory<T> {
    protected static final String NAME = "bean.name";
    protected static final String[] EMPTY = new String[0];
    private KernelConfigurator configurator;
    private final ClassInfo OBJECT;

    public AbstractDictionaryFactory(KernelConfigurator configurator) {
        if (configurator == null) {
            throw new IllegalArgumentException("Null configurator");
        }
        this.configurator = configurator;
        this.OBJECT = this.getClassInfo(Object.class);
    }

    protected ClassInfo getClassInfo(Class<?> clazz) {
        try {
            return this.configurator.getClassInfo(clazz);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected class GenericDictionary
    extends AbstractDictionary {
        protected GenericDictionary(ControllerContext context) {
            super(context);
        }

        @Override
        protected String[] getClasses(ControllerContext context) {
            Object target = context.getTarget();
            ClassInfo clazz = target != null ? AbstractDictionaryFactory.this.getClassInfo(target.getClass()) : this.getFromNullTarget(context);
            String[] classes = EMPTY;
            if (clazz != null) {
                HashSet<String> clazzes = new HashSet<String>();
                this.traverseClass(clazz, clazzes);
                classes = clazzes.toArray(new String[clazzes.size()]);
                this.put("objectClass", (Object)classes);
            }
            return classes;
        }

        protected ClassInfo getFromNullTarget(ControllerContext context) {
            return null;
        }

        protected void traverseClass(ClassInfo clazz, Set<String> classes) {
            if (clazz == null || clazz == AbstractDictionaryFactory.this.OBJECT) {
                return;
            }
            classes.add(clazz.getName());
            this.traverseClass(clazz.getSuperclass(), classes);
            InterfaceInfo[] interfaces = clazz.getInterfaces();
            if (interfaces != null) {
                for (InterfaceInfo intface : interfaces) {
                    this.traverseClass((ClassInfo)intface, classes);
                }
            }
        }
    }

    protected abstract class AbstractDictionary
    extends Dictionary<String, Object> {
        private Map<Object, Object> map;
        private ControllerContext context;

        protected AbstractDictionary(ControllerContext context) {
            this.context = context;
            this.map = new ConcurrentHashMap<Object, Object>(2);
            this.map.put(AbstractDictionaryFactory.NAME, this.getName(context));
            this.map.put("objectClass", EMPTY);
        }

        protected Object getName(ControllerContext context) {
            return context.getName();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Enumeration<String> keys() {
            return Iterators.toEnumeration(this.map.keySet().iterator());
        }

        @Override
        public Enumeration<Object> elements() {
            return Iterators.toEnumeration(this.map.values().iterator());
        }

        @Override
        public Object get(Object key) {
            Object value = this.map.get(key);
            if (value != EMPTY) {
                return value;
            }
            return this.getClasses(this.context);
        }

        protected abstract String[] getClasses(ControllerContext var1);

        @Override
        public Object put(String key, Object value) {
            return this.map.put(key, value);
        }

        @Override
        public Object remove(Object key) {
            return this.map.remove(key);
        }
    }
}

