/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentResourceLoader;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.deployers.AbstractDeployment;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public abstract class DeployedBundleState
extends AbstractBundleState {
    private static final AtomicLong bundleIDGenerator = new AtomicLong();
    private long bundleId;
    private String location;
    private VirtualFile rootFile;
    private OSGiMetaData osgiMetaData;
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    Dictionary<String, String> headersOnUninstall;
    private Version version;

    public DeployedBundleState(OSGiBundleManager bundleManager, DeploymentUnit unit) {
        super(bundleManager);
        if (unit == null) {
            throw new IllegalArgumentException("Null deployment unit");
        }
        Deployment dep = (Deployment)unit.getAttachment(Deployment.class);
        this.location = dep != null ? dep.getLocation() : unit.getName();
        this.rootFile = dep != null ? dep.getRoot() : AbstractDeployment.getRoot(unit);
        this.bundleId = bundleIDGenerator.incrementAndGet();
        this.osgiMetaData = (OSGiMetaData)unit.getAttachment(OSGiMetaData.class);
        this.addDeploymentUnit(unit);
    }

    public static DeployedBundleState assertBundleState(Bundle bundle) {
        if (!((bundle = AbstractBundleState.assertBundleState(bundle)) instanceof DeployedBundleState)) {
            throw new IllegalArgumentException("Not an AbstractDeployedBundleState: " + bundle);
        }
        return (DeployedBundleState)bundle;
    }

    public VirtualFile getRoot() {
        return this.rootFile;
    }

    @Override
    public OSGiMetaData getOSGiMetaData() {
        return this.osgiMetaData;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public String getLocation() {
        return this.location;
    }

    public Version getVersion() {
        if (this.version == null) {
            String versionstr = this.getOSGiMetaData().getBundleVersion();
            this.version = Version.parseVersion((String)versionstr);
        }
        return this.version;
    }

    public DeploymentUnit getDeploymentUnit() {
        int index = this.units.size() - 1;
        return this.units.get(index);
    }

    void addDeploymentUnit(DeploymentUnit unit) {
        unit.getMutableMetaData().addMetaData((Object)unit, DeploymentUnit.class);
        this.units.add(unit);
    }

    List<DeploymentUnit> getDeploymentUnits() {
        return Collections.unmodifiableList(this.units);
    }

    public void update(InputStream in) throws BundleException {
        this.checkAdminPermission("lifecycle");
        try {
            this.getBundleManager().updateBundle(this, in);
            this.osgiMetaData = (OSGiMetaData)this.getDeploymentUnit().getAttachment(OSGiMetaData.class);
            this.version = Version.parseVersion((String)this.osgiMetaData.getBundleVersion());
        }
        catch (Exception ex) {
            if (ex instanceof BundleException) {
                throw (BundleException)((Object)ex);
            }
            throw new BundleException("Cannot update bundle: " + (Object)((Object)this), (Throwable)ex);
        }
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        if (this.getState() == 1) {
            return this.headersOnUninstall;
        }
        return super.getHeaders(locale);
    }

    public URL getEntry(String path) {
        this.checkInstalled();
        if (this.noAdminPermission("resource")) {
            return null;
        }
        return this.getEntryInternal(path);
    }

    public Enumeration getEntryPaths(String path) {
        this.checkInstalled();
        if (this.noAdminPermission("resource")) {
            return null;
        }
        try {
            return this.rootFile.getEntryPaths(path);
        }
        catch (IOException e) {
            throw new RuntimeException("Error determining entry paths for " + this.rootFile + " path=" + path);
        }
    }

    @Override
    protected URL getEntryInternal(String path) {
        VFSDeploymentUnit unit = (VFSDeploymentUnit)this.getDeploymentUnit();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        VFSDeploymentResourceLoader loader = unit.getResourceLoader();
        URL resource = loader.getResource(path);
        return resource;
    }

    public void uninstall() throws BundleException {
        this.checkAdminPermission("lifecycle");
        if (this.getState() == 1) {
            throw new IllegalStateException("Bundle already uninstalled: " + (Object)((Object)this));
        }
        this.headersOnUninstall = this.getHeaders(null);
        this.getBundleManager().uninstallBundle(this);
    }

    public Enumeration findEntries(String path, String pattern, boolean recurse) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        this.checkInstalled();
        if (this.noAdminPermission("resource")) {
            return null;
        }
        this.getBundleManager().resolveBundle(this);
        try {
            return this.rootFile.findEntries(path, pattern, recurse);
        }
        catch (IOException e) {
            throw new RuntimeException("Error finding entries for " + this.rootFile + " path=" + path + " pattern=" + pattern + " recurse=" + recurse);
        }
    }
}

