/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeLevel;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.ContextComparator;
import org.jboss.osgi.framework.bundle.ControllerContextHandle;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.plugins.ServiceManagerPlugin;
import org.jboss.osgi.framework.util.KernelUtils;

public class MDRUtils {
    private static final Logger log = Logger.getLogger(MDRUtils.class);
    private static Map<ControllerContext, Dictionary<String, Object>> propertiesCache = new WeakHashMap<ControllerContext, Dictionary<String, Object>>();

    static Dictionary<String, Object> getProperties(ControllerContext context) {
        MetaData metaData = MDRUtils.getMetaData(context, CommonLevels.INSTANCE);
        Dictionary<String, Object> properties = (Dictionary<String, Object>)metaData.getMetaData(Dictionary.class);
        if (properties != null) {
            return properties;
        }
        properties = propertiesCache.get(context);
        if (properties == null) {
            properties = new Hashtable<String, Object>();
            propertiesCache.put(context, properties);
        }
        return properties;
    }

    static <T> T getProperty(ControllerContext context, String key, Class<T> expectedType) {
        return MDRUtils.getProperty(context, key, expectedType, null);
    }

    static <T> T getProperty(ControllerContext context, String key, Class<T> expectedType, T defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expected type");
        }
        Dictionary<String, Object> properties = MDRUtils.getProperties(context);
        Object result = properties.get(key);
        if (result != null && !expectedType.isInstance(result)) {
            if (defaultValue == null) {
                throw new IllegalArgumentException("Illegal result type: " + result + ", expected: " + expectedType);
            }
            result = defaultValue;
        }
        if (result == null) {
            result = defaultValue;
        }
        return expectedType.cast(result);
    }

    private static Object getSource(AbstractBundleState bundleState, String className) {
        if (bundleState.getState() == 1) {
            return null;
        }
        OSGiBundleManager bundleManager = bundleState.getBundleManager();
        return bundleManager.loadClassFailsafe(bundleState, className);
    }

    private static ClassLoader getClassLoader(Object instance) {
        return instance instanceof Class ? ((Class)Class.class.cast(instance)).getClassLoader() : instance.getClass().getClassLoader();
    }

    public static boolean matchClass(ControllerContext context, String clazz) {
        String[] classes = MDRUtils.getClasses(context);
        return classes != null && Arrays.asList(classes).contains(clazz);
    }

    public static Integer getRanking(ControllerContext context) {
        return MDRUtils.getProperty(context, "service.ranking", Integer.class, 0);
    }

    public static Long getId(ControllerContext context) {
        return MDRUtils.getProperty(context, "service.id", Long.class);
    }

    public static String[] getClasses(ControllerContext context) {
        return MDRUtils.getProperty(context, "objectClass", String[].class);
    }

    public static boolean isAssignableTo(ControllerContext context, AbstractBundleState sourceBundle, AbstractBundleState targetBundle, String className) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (sourceBundle == null) {
            throw new IllegalArgumentException("Null source bundle");
        }
        if (targetBundle == null) {
            throw new IllegalArgumentException("Null target bundle");
        }
        if (className == null) {
            throw new IllegalArgumentException("Null class name");
        }
        if (sourceBundle == targetBundle) {
            return true;
        }
        if (KernelUtils.isUnregistered(context)) {
            return false;
        }
        return MDRUtils.isAssignableTo(sourceBundle, targetBundle, className);
    }

    public static boolean isAssignableTo(ControllerContext context, AbstractBundleState sourceBundle, AbstractBundleState targetBundle, String[] classNames) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (sourceBundle == null) {
            throw new IllegalArgumentException("Null source bundle");
        }
        if (targetBundle == null) {
            throw new IllegalArgumentException("Null target bundle");
        }
        if (classNames == null) {
            throw new IllegalArgumentException("Null class names");
        }
        if (sourceBundle == targetBundle) {
            return true;
        }
        if (KernelUtils.isUnregistered(context)) {
            return false;
        }
        for (String className : classNames) {
            if (MDRUtils.isAssignableTo(sourceBundle, targetBundle, className)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignableTo(AbstractBundleState sourceBundle, AbstractBundleState targetBundle, String className) {
        if (sourceBundle == null) {
            throw new IllegalArgumentException("Null source bundle");
        }
        if (className == null) {
            throw new IllegalArgumentException("Null class name");
        }
        Object source = MDRUtils.getSource(sourceBundle, className);
        if (source == null) {
            return ((Object)((Object)sourceBundle)).equals((Object)targetBundle);
        }
        Object target = MDRUtils.getSource(targetBundle, className);
        if (target == null) {
            log.debug((Object)("Cannot load '" + className + "' from: " + (Object)((Object)targetBundle)));
            return true;
        }
        boolean equals = source.equals(target);
        if (!equals) {
            ClassLoader targetLoader = MDRUtils.getClassLoader(target);
            ClassLoader sourceLoader = MDRUtils.getClassLoader(source);
            StringBuffer buffer = new StringBuffer("Cannot assign '" + className + "' comming from different exporters");
            buffer.append("\n  source: ").append(sourceLoader);
            buffer.append("\n  target: ").append(targetLoader);
            log.warn((Object)buffer.toString());
        }
        return equals;
    }

    public static boolean isAssignableTo(ControllerContext context, AbstractBundleState sourceBundle, String className) {
        if (sourceBundle == null) {
            throw new IllegalArgumentException("Null bundle state");
        }
        OSGiBundleManager manager = sourceBundle.getBundleManager();
        ServiceManagerPlugin plugin = manager.getPlugin(ServiceManagerPlugin.class);
        AbstractBundleState targetBundle = plugin.getBundleForContext(context);
        return MDRUtils.isAssignableTo(context, sourceBundle, targetBundle, className);
    }

    public static boolean isAssignableTo(ControllerContext context, AbstractBundleState sourceBundle) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (sourceBundle == null) {
            throw new IllegalArgumentException("Null bundle state");
        }
        OSGiBundleManager manager = sourceBundle.getBundleManager();
        ServiceManagerPlugin plugin = manager.getPlugin(ServiceManagerPlugin.class);
        AbstractBundleState targetBundle = plugin.getBundleForContext(context);
        if (sourceBundle == targetBundle) {
            return true;
        }
        if (KernelUtils.isUnregistered(context)) {
            return false;
        }
        String[] classes = MDRUtils.getProperty(context, "objectClass", String[].class);
        if (classes == null) {
            return false;
        }
        for (String className : classes) {
            if (MDRUtils.isAssignableTo(sourceBundle, targetBundle, className)) continue;
            return false;
        }
        return true;
    }

    private static MetaData getMetaData(ControllerContext context, ScopeLevel level) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        MetaData metaData = context.getScopeInfo().getMetaData();
        if (level != null && metaData != null) {
            metaData = metaData.getScopeMetaData(level);
        }
        if (metaData == null) {
            throw new IllegalStateException("Cannot obtain " + level + " meta data for: " + context);
        }
        return metaData;
    }

    public static int compareTo(ControllerContext context, Object reference) {
        ControllerContext other;
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (reference == null) {
            throw new IllegalArgumentException("Null reference");
        }
        if (reference instanceof ControllerContext) {
            other = (ControllerContext)reference;
        } else if (reference instanceof ControllerContextHandle) {
            other = ((ControllerContextHandle)reference).getContext();
        } else {
            throw new IllegalArgumentException(reference + " is not a service reference");
        }
        Comparator<ControllerContext> comparator = ContextComparator.getInstance();
        return comparator.compare(context, other);
    }
}

