/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.IncompleteDeploymentException;
import org.jboss.deployers.client.spi.IncompleteDeployments;
import org.jboss.deployers.client.spi.MissingDependency;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.kernel.Kernel;
import org.jboss.logging.Logger;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.DeployedBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleValidator;
import org.jboss.osgi.framework.bundle.OSGiBundleValidatorR3;
import org.jboss.osgi.framework.bundle.OSGiBundleValidatorR4;
import org.jboss.osgi.framework.bundle.OSGiBundleWrapper;
import org.jboss.osgi.framework.bundle.OSGiFragmentState;
import org.jboss.osgi.framework.bundle.OSGiSystemState;
import org.jboss.osgi.framework.classloading.OSGiRequirement;
import org.jboss.osgi.framework.deployers.AbstractDeployment;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.ParameterizedAttribute;
import org.jboss.osgi.framework.plugins.AutoInstallPlugin;
import org.jboss.osgi.framework.plugins.BundleStoragePlugin;
import org.jboss.osgi.framework.plugins.FrameworkEventsPlugin;
import org.jboss.osgi.framework.plugins.FrameworkProperties;
import org.jboss.osgi.framework.plugins.PackageAdminPlugin;
import org.jboss.osgi.framework.plugins.Plugin;
import org.jboss.osgi.framework.plugins.ResolverPlugin;
import org.jboss.osgi.framework.plugins.ServicePlugin;
import org.jboss.osgi.framework.plugins.StartLevelPlugin;
import org.jboss.osgi.framework.util.URLHelper;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;

public class OSGiBundleManager {
    private static final Logger log = Logger.getLogger(OSGiBundleManager.class);
    public static final String BEAN_BUNDLE_MANAGER = "OSGiBundleManager";
    private List<AbstractBundleState> allBundles = new CopyOnWriteArrayList<AbstractBundleState>();
    private Kernel kernel;
    private DeployerClient deployerClient;
    private Executor executor;
    private OSGiSystemState systemBundle;
    private ClassLoaderDomain classLoaderDomain;
    private Map<Class<?>, Plugin> plugins = Collections.synchronizedMap(new LinkedHashMap());
    private FrameworkProperties properties;
    private AtomicInteger stopMonitor = new AtomicInteger(0);

    public OSGiBundleManager(Kernel kernel, FrameworkProperties properties, DeployerClient deployerClient) {
        this(kernel, properties, deployerClient, null);
    }

    public OSGiBundleManager(Kernel kernel, FrameworkProperties properties, DeployerClient deployerClient, Executor executor) {
        if (kernel == null) {
            throw new IllegalArgumentException("Null kernel");
        }
        if (deployerClient == null) {
            throw new IllegalArgumentException("Null deployerClient");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Null properties");
        }
        if (!(deployerClient instanceof MainDeployerStructure)) {
            throw new IllegalArgumentException("Deployer client does not implement " + MainDeployerStructure.class.getName());
        }
        this.kernel = kernel;
        this.deployerClient = deployerClient;
        this.properties = properties;
        if (executor == null) {
            executor = Executors.newFixedThreadPool(10);
        }
        this.executor = executor;
    }

    public void start() {
        this.systemBundle = new OSGiSystemState(this);
        this.addBundle(this.systemBundle);
    }

    public void stop() {
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public DeployerClient getDeployerClient() {
        return this.deployerClient;
    }

    public ClassLoaderDomain getClassLoaderDomain() {
        if (this.classLoaderDomain == null) {
            throw new IllegalStateException("ClassLoaderDomain not available");
        }
        return this.classLoaderDomain;
    }

    public void setClassLoaderDomain(ClassLoaderDomain domain) {
        this.classLoaderDomain = domain;
    }

    public void setProperties(Map<String, Object> props) {
        this.properties.setProperties(props);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public <T extends Plugin> T getPlugin(Class<T> clazz) {
        Plugin plugin = this.plugins.get(clazz);
        if (plugin == null) {
            throw new IllegalStateException("Cannot obtain plugin for: " + clazz.getName());
        }
        return (T)plugin;
    }

    public <T extends Plugin> T getOptionalPlugin(Class<T> clazz) {
        return (T)this.plugins.get(clazz);
    }

    public void addPlugin(Plugin plugin) {
        Class<?> key = this.getPluginKey(plugin);
        log.debug((Object)("Add plugin: " + key.getName()));
        this.plugins.put(key, plugin);
        if (this.isFrameworkActive() && plugin instanceof ServicePlugin) {
            ServicePlugin servicePlugin = (ServicePlugin)plugin;
            servicePlugin.startService();
        }
    }

    private Class<?> getPluginKey(Plugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Null plugin");
        }
        Class<?> clazz = plugin.getClass();
        Class<?> key = this.getPluginKey(plugin, clazz);
        return key != null ? key : clazz;
    }

    private Class<?> getPluginKey(Plugin plugin, Class<?> clazz) {
        for (Class<?> interf : clazz.getInterfaces()) {
            if (interf == Plugin.class || interf == ServicePlugin.class || !Plugin.class.isAssignableFrom(interf)) continue;
            return interf;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (Plugin.class.isAssignableFrom(superclass)) {
            return this.getPluginKey(plugin, superclass);
        }
        return null;
    }

    public void removePlugin(Plugin plugin) {
        Class<?> key = this.getPluginKey(plugin);
        log.debug((Object)("Remove plugin: " + key.getName()));
        this.plugins.remove(key);
    }

    public boolean isFrameworkActive() {
        OSGiSystemState bundleState = this.getSystemBundle();
        return bundleState.getState() == 32;
    }

    public AbstractBundleState installBundle(URL url) throws BundleException {
        if (url == null) {
            throw new BundleException("Null url");
        }
        return this.installBundle(url.toExternalForm(), null);
    }

    public AbstractBundleState installBundle(String location, InputStream input) throws BundleException {
        VirtualFile root;
        if (location == null) {
            throw new BundleException("Null location");
        }
        URL locationURL = input != null ? this.getBundleStorageLocation(input) : this.getLocationURL(location);
        try {
            root = AbstractVFS.getRoot((URL)locationURL);
        }
        catch (IOException e) {
            throw new BundleException("Invalid bundle location=" + locationURL, (Throwable)e);
        }
        return this.install(root, location, false);
    }

    private URL getBundleStorageLocation(InputStream input) throws BundleException {
        try {
            BundleStoragePlugin plugin = this.getPlugin(BundleStoragePlugin.class);
            String path = plugin.getStorageDir(this.getSystemBundle()).getCanonicalPath();
            File file = new File(path + "/bundle-" + System.currentTimeMillis() + ".jar");
            FileOutputStream fos = new FileOutputStream(file);
            VFSUtils.copyStream((InputStream)input, (OutputStream)fos);
            fos.close();
            URL locationURL = file.toURI().toURL();
            return locationURL;
        }
        catch (IOException ex) {
            throw new BundleException("Cannot store bundle from input stream", (Throwable)ex);
        }
    }

    public AbstractBundleState installBundle(VirtualFile root) throws BundleException {
        return this.install(root, root.toString(), false);
    }

    private AbstractBundleState install(VirtualFile root, String location, boolean autoStart) throws BundleException {
        Deployment dep;
        if (location == null) {
            throw new IllegalArgumentException("Null location");
        }
        try {
            BundleInfo info = BundleInfo.createBundleInfo((VirtualFile)root, (String)location);
            dep = DeploymentFactory.createDeployment((BundleInfo)info);
            dep.setAutoStart(autoStart);
        }
        catch (RuntimeException ex) {
            throw new BundleException("Cannot install bundle: " + root, (Throwable)ex);
        }
        return this.installBundle(dep);
    }

    public AbstractBundleState installBundle(Deployment dep) throws BundleException {
        if (dep == null) {
            throw new IllegalArgumentException("Null deployment");
        }
        AbstractBundleState bundleState = this.getBundleByLocation(dep.getLocation());
        if (bundleState != null) {
            return bundleState;
        }
        try {
            org.jboss.deployers.client.spi.Deployment deployment = AbstractDeployment.createDeployment(dep.getRoot());
            MutableAttachments att = (MutableAttachments)deployment.getPredeterminedManagedObjects();
            att.addAttachment(Deployment.class, (Object)dep);
            bundleState = (AbstractBundleState)((Object)dep.getAttachment(AbstractBundleState.class));
            if (bundleState != null) {
                att.addAttachment(AbstractBundleState.class, (Object)bundleState);
            }
            this.deployerClient.deploy(new org.jboss.deployers.client.spi.Deployment[]{deployment});
            try {
                MainDeployerStructure deployerStructure = (MainDeployerStructure)this.deployerClient;
                DeploymentUnit unit = deployerStructure.getDeploymentUnit(deployment.getName());
                bundleState = (AbstractBundleState)((Object)unit.getAttachment(AbstractBundleState.class));
                if (bundleState == null) {
                    throw new IllegalStateException("Unable to determine bundle state for " + deployment.getName());
                }
                return bundleState;
            }
            catch (Exception e) {
                this.deployerClient.undeploy(new org.jboss.deployers.client.spi.Deployment[]{deployment});
                throw e;
            }
        }
        catch (IncompleteDeploymentException ex) {
            String errorMessage = this.getIncompleteDeploymentInfo(dep, ex);
            throw new BundleException(errorMessage);
        }
        catch (Exception ex) {
            throw new BundleException("Error installing bundle from: " + dep, (Throwable)ex);
        }
    }

    private String getIncompleteDeploymentInfo(Deployment dep, IncompleteDeploymentException ex) {
        Collection missingDeployers;
        Collection missingDependencies;
        Collection deploymentsInError;
        IncompleteDeployments deployments = ex.getIncompleteDeployments();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Error installing bundle from: " + dep);
        Collection contextsError = deployments.getContextsInError().values();
        if (contextsError.size() > 0) {
            printWriter.println("\nContext Errors:");
            for (Throwable th : contextsError) {
                printWriter.println("\n");
                th.printStackTrace(printWriter);
            }
        }
        if ((deploymentsInError = deployments.getDeploymentsInError().values()).size() > 0) {
            printWriter.println("\nDeployment Errors:");
            for (Throwable th : deploymentsInError) {
                printWriter.println("\n");
                th.printStackTrace(printWriter);
            }
        }
        if ((missingDependencies = deployments.getContextsMissingDependencies().values()).size() > 0) {
            printWriter.println("\nMissing Dependencies:");
            for (Set missDeps : missingDependencies) {
                for (MissingDependency missDep : missDeps) {
                    printWriter.println("\n  " + missDep);
                }
            }
        }
        if ((missingDeployers = deployments.getDeploymentsMissingDeployer()).size() > 0) {
            printWriter.println("\nMissing Deployers:");
            for (String missDep : missingDeployers) {
                printWriter.println("\n  " + missDep);
            }
        }
        String errorMessage = stringWriter.toString();
        return errorMessage;
    }

    public void updateBundle(DeployedBundleState bundleState, InputStream in) throws BundleException {
        BundleException throwAfterUpdate;
        AbstractBundleState updatedBundleState;
        boolean activeBeforeUpdate;
        block11: {
            URL updateURL = bundleState.getOSGiMetaData().getBundleUpdateLocation();
            if (updateURL == null) {
                VirtualFile root = bundleState.getRoot();
                updateURL = URLHelper.toURL(root);
            }
            if (in == null) {
                try {
                    in = updateURL.openStream();
                }
                catch (IOException ex) {
                    throw new BundleException("Cannot obtain update input stream for: " + (Object)((Object)bundleState), (Throwable)ex);
                }
            }
            boolean bl = activeBeforeUpdate = bundleState.getState() == 32;
            if (bundleState.getState() == 1) {
                throw new IllegalStateException("Bundle already uninstalled: " + this);
            }
            if (bundleState.getState() == 32 || bundleState.getState() == 8 || bundleState.getState() == 16) {
                this.stopBundle(bundleState);
            }
            String location = updateURL != null ? updateURL.toExternalForm() : bundleState.getCanonicalName() + "/update";
            updatedBundleState = null;
            throwAfterUpdate = null;
            try {
                URL storageLocation = this.getBundleStorageLocation(in);
                VirtualFile root = AbstractVFS.getRoot((URL)storageLocation);
                BundleInfo info = BundleInfo.createBundleInfo((VirtualFile)root, (String)location);
                Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
                dep.addAttachment(AbstractBundleState.class, (Object)bundleState);
                dep.setBundleUpdate(true);
                dep.setAutoStart(false);
                updatedBundleState = this.installBundle(dep);
                updatedBundleState.updateLastModified();
            }
            catch (Exception ex) {
                throwAfterUpdate = ex instanceof BundleException ? (BundleException)((Object)ex) : new BundleException("Cannot install updated bundle from: " + location, (Throwable)ex);
                if (!activeBeforeUpdate) break block11;
                this.startBundle(bundleState);
            }
        }
        if (updatedBundleState != null) {
            FrameworkEventsPlugin plugin = this.getPlugin(FrameworkEventsPlugin.class);
            plugin.fireBundleEvent(updatedBundleState, 8);
            if (activeBeforeUpdate && !updatedBundleState.isFragment()) {
                this.startBundle((DeployedBundleState)updatedBundleState);
            }
        }
        if (throwAfterUpdate != null) {
            throw throwAfterUpdate;
        }
    }

    public void uninstallBundle(DeployedBundleState bundleState) throws BundleException {
        long id = bundleState.getBundleId();
        if (this.getBundleById(id) == null) {
            throw new BundleException((Object)((Object)bundleState) + " not installed");
        }
        int state = bundleState.getState();
        if (state == 32 || state == 8 || state == 16) {
            try {
                if (!bundleState.isFragment()) {
                    this.stopBundle(bundleState);
                }
            }
            catch (Exception ex) {
                this.fireError(bundleState, "Error stopping bundle: " + (Object)((Object)bundleState), ex);
            }
        }
        DeploymentException depEx = null;
        for (DeploymentUnit unit : bundleState.getDeploymentUnits()) {
            try {
                this.deployerClient.undeploy(new String[]{unit.getName()});
                bundleState.updateLastModified();
            }
            catch (DeploymentException ex) {
                depEx = ex;
                log.error((Object)("Cannot undeploy: " + unit.getName()), (Throwable)depEx);
            }
        }
        if (depEx != null) {
            Throwable cause = depEx.getCause();
            if (cause instanceof BundleException) {
                throw (BundleException)cause;
            }
            throw new BundleException("Unable to uninstall " + (Object)((Object)bundleState), cause);
        }
    }

    public AbstractBundleState addDeployment(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        AbstractBundleState absBundle = (AbstractBundleState)((Object)unit.getAttachment(AbstractBundleState.class));
        if (absBundle != null) {
            OSGiBundleState depBundle = (OSGiBundleState)absBundle;
            depBundle.addDeploymentUnit(unit);
        } else {
            OSGiMetaData osgiMetaData = (OSGiMetaData)unit.getAttachment(OSGiMetaData.class);
            ParameterizedAttribute fragmentHost = osgiMetaData.getFragmentHost();
            if (fragmentHost != null) {
                OSGiFragmentState fragmentState = new OSGiFragmentState(this, unit);
                absBundle = fragmentState;
            } else {
                OSGiBundleState bundleState = new OSGiBundleState(this, unit);
                absBundle = bundleState;
            }
        }
        unit.addAttachment(AbstractBundleState.class, (Object)absBundle);
        if (absBundle.isFragment()) {
            unit.addAttachment(OSGiFragmentState.class, (Object)((OSGiFragmentState)absBundle));
        } else {
            unit.addAttachment(OSGiBundleState.class, (Object)((OSGiBundleState)absBundle));
        }
        return absBundle;
    }

    public void addBundle(AbstractBundleState bundleState) {
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundle state");
        }
        if (bundleState instanceof OSGiBundleState) {
            DeploymentUnit unit = ((DeployedBundleState)bundleState).getDeploymentUnit();
            if (unit.getAttachment(ClassLoadingMetaData.class) == null) {
                throw new IllegalStateException("Cannot obtain ClassLoadingMetaData");
            }
            Deployment dep = (Deployment)unit.getAttachment(Deployment.class);
            if (dep != null && dep.isBundleUpdate()) {
                return;
            }
        }
        if (bundleState instanceof DeployedBundleState) {
            this.validateBundle((DeployedBundleState)bundleState);
        }
        this.allBundles.add(bundleState);
        try {
            bundleState.changeState(2, true);
        }
        catch (RuntimeException rte) {
            this.allBundles.remove((Object)bundleState);
            throw rte;
        }
        log.debug((Object)("Added: " + (Object)((Object)bundleState)));
    }

    private void validateBundle(DeployedBundleState bundleState) {
        OSGiMetaData osgiMetaData = bundleState.getOSGiMetaData();
        if (osgiMetaData == null) {
            return;
        }
        OSGiBundleValidator validator = osgiMetaData.getBundleManifestVersion() > 1 ? new OSGiBundleValidatorR4(this) : new OSGiBundleValidatorR3(this);
        validator.validateBundle(bundleState);
    }

    public void removeBundle(AbstractBundleState bundleState) {
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundle state");
        }
        bundleState.uninstallInternal();
        this.allBundles.remove((Object)bundleState);
        log.debug((Object)("Removed " + bundleState.getCanonicalName()));
    }

    public OSGiSystemState getSystemBundle() {
        return this.systemBundle;
    }

    public BundleContext getSystemContext() {
        return this.systemBundle.getBundleContext();
    }

    public DeploymentUnit getDeployment(long id) {
        if (id == 0L) {
            throw new IllegalArgumentException("Cannot get deployment from system bundle");
        }
        DeployedBundleState bundleState = (DeployedBundleState)this.getBundleById(id);
        if (bundleState == null) {
            return null;
        }
        return bundleState.getDeploymentUnit();
    }

    public AbstractBundleState getBundleById(long id) {
        AbstractBundleState result = null;
        for (AbstractBundleState aux : this.allBundles) {
            if (id != aux.getBundleId()) continue;
            result = aux;
            break;
        }
        return result;
    }

    public AbstractBundleState getBundle(String symbolicName, Version version) {
        AbstractBundleState result = null;
        for (AbstractBundleState aux : this.allBundles) {
            String auxName = aux.getSymbolicName();
            Version auxVersion = aux.getVersion();
            if (!auxName.equals(symbolicName) || !auxVersion.equals((Object)version)) continue;
            result = aux;
            break;
        }
        return result;
    }

    public AbstractBundleState getBundleState(Bundle bundle) {
        if (bundle instanceof OSGiBundleWrapper) {
            bundle = ((OSGiBundleWrapper)bundle).getBundleState();
        }
        if (!(bundle instanceof AbstractBundleState)) {
            throw new IllegalArgumentException("Cannot obtain bunde state from: " + bundle);
        }
        return (AbstractBundleState)bundle;
    }

    public AbstractBundleState getBundleByLocation(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Null location");
        }
        AbstractBundleState result = null;
        for (AbstractBundleState aux : this.allBundles) {
            DeploymentUnit unit;
            String auxLocation = aux.getLocation();
            if (location.equals(auxLocation)) {
                result = aux;
                break;
            }
            if (!(aux instanceof DeployedBundleState) || !location.equals((unit = ((DeployedBundleState)aux).getDeploymentUnit()).getName())) continue;
            result = aux;
            break;
        }
        return result;
    }

    public Collection<AbstractBundleState> getBundles() {
        ArrayList<AbstractBundleState> bundles = new ArrayList<AbstractBundleState>();
        for (AbstractBundleState aux : this.allBundles) {
            bundles.add(aux);
        }
        return Collections.unmodifiableList(bundles);
    }

    public Collection<AbstractBundleState> getBundles(int states) {
        ArrayList<AbstractBundleState> bundles = new ArrayList<AbstractBundleState>();
        for (AbstractBundleState aux : this.allBundles) {
            if ((aux.getState() & states) <= 0) continue;
            bundles.add(aux);
        }
        return Collections.unmodifiableList(bundles);
    }

    public void startBundle(DeployedBundleState bundleState) throws BundleException {
        if (bundleState.getState() == 1) {
            throw new IllegalStateException("Bundle already uninstalled: " + this);
        }
        if (bundleState.getState() == 32) {
            return;
        }
        if (bundleState.getState() != 4) {
            PackageAdmin packageAdmin = this.getPlugin(PackageAdminPlugin.class);
            packageAdmin.resolveBundles(null);
            if (bundleState.getState() != 4) {
                StringBuffer buffer = new StringBuffer("Cannot resolve bundle " + (Object)((Object)bundleState));
                ResolverPlugin resolver = this.getOptionalPlugin(ResolverPlugin.class);
                if (resolver != null) {
                    List<OSGiRequirement> unresolved = resolver.getUnresolvedRequirements(bundleState);
                    buffer.append(" " + unresolved);
                }
                throw new BundleException(buffer.toString());
            }
        }
        try {
            DeploymentUnit unit = bundleState.getDeploymentUnit();
            this.deployerClient.change(unit.getName(), DeploymentStages.INSTALLED);
            this.deployerClient.checkComplete(new String[]{unit.getName()});
            BundleException startEx = (BundleException)((Object)unit.removeAttachment(BundleException.class));
            if (startEx != null) {
                this.deployerClient.change(unit.getName(), DeploymentStages.CLASSLOADER);
                this.deployerClient.checkComplete(new String[]{unit.getName()});
                throw startEx;
            }
        }
        catch (DeploymentException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof BundleException) {
                throw (BundleException)cause;
            }
            throw new BundleException("Error starting " + (Object)((Object)bundleState), cause != null ? cause : ex);
        }
    }

    public void stopBundle(DeployedBundleState bundleState) throws BundleException {
        if (bundleState.getState() == 1) {
            throw new IllegalStateException("Bundle already uninstalled: " + this);
        }
        if (bundleState.getState() != 8 && bundleState.getState() != 32) {
            return;
        }
        try {
            DeploymentUnit unit = bundleState.getDeploymentUnit();
            this.deployerClient.change(unit.getName(), DeploymentStages.CLASSLOADER);
            this.deployerClient.checkComplete(new String[]{unit.getName()});
            BundleException stopEx = (BundleException)((Object)unit.removeAttachment(BundleException.class));
            if (stopEx != null) {
                throw stopEx;
            }
        }
        catch (DeploymentException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof BundleException) {
                throw (BundleException)cause;
            }
            throw new BundleException("Error stopping " + (Object)((Object)bundleState), cause != null ? cause : ex);
        }
    }

    public boolean resolveBundle(AbstractBundleState bundle) {
        Bundle[] bundleArray;
        PackageAdminPlugin packageAdmin = this.getPlugin(PackageAdminPlugin.class);
        if (bundle != null) {
            Bundle[] bundleArray2 = new Bundle[1];
            bundleArray = bundleArray2;
            bundleArray2[0] = bundle;
        } else {
            bundleArray = null;
        }
        Bundle[] bundles = bundleArray;
        return packageAdmin.resolveBundles(bundles);
    }

    Class<?> loadClassFailsafe(Bundle bundle, String clazz) {
        try {
            return bundle.loadClass(clazz);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    Executor getExecutor() {
        return this.executor;
    }

    public void initFramework() throws BundleException {
        String implTitle = this.getClass().getPackage().getImplementationTitle();
        String implVersion = this.getClass().getPackage().getImplementationVersion();
        log.info((Object)(implTitle + " - " + implVersion));
        int state = this.systemBundle.getState();
        if (state == 8 || state == 32 || state == 16) {
            return;
        }
        this.systemBundle.changeState(8);
        this.systemBundle.start();
        FrameworkEventsPlugin eventsPlugin = this.getPlugin(FrameworkEventsPlugin.class);
        eventsPlugin.setActive(true);
        for (Plugin plugin : new ArrayList<Plugin>(this.plugins.values())) {
            if (!(plugin instanceof ServicePlugin)) continue;
            ServicePlugin servicePlugin = (ServicePlugin)plugin;
            servicePlugin.startService();
        }
        String storageClean = this.properties.getProperty("org.osgi.framework.storage.clean");
        BundleStoragePlugin storagePlugin = this.getOptionalPlugin(BundleStoragePlugin.class);
        if (storagePlugin != null) {
            storagePlugin.cleanStorage(storageClean);
        }
    }

    public void startFramework() throws BundleException {
        StartLevelPlugin startLevel;
        ResolverPlugin resolver;
        AutoInstallPlugin autoInstall;
        if (this.systemBundle.getState() != 8) {
            this.initFramework();
        }
        if ((autoInstall = this.getOptionalPlugin(AutoInstallPlugin.class)) != null) {
            autoInstall.installBundles();
            autoInstall.startBundles();
        }
        if ((resolver = this.getOptionalPlugin(ResolverPlugin.class)) != null) {
            resolver.addBundle(this.systemBundle);
            resolver.resolve(Collections.singletonList(this.systemBundle.getBundleInternal()));
        }
        if ((startLevel = this.getOptionalPlugin(StartLevelPlugin.class)) != null) {
            startLevel.increaseStartLevel(startLevel.getInitialBundleStartLevel());
        }
        this.systemBundle.changeState(32);
        FrameworkEventsPlugin plugin = this.getPlugin(FrameworkEventsPlugin.class);
        plugin.fireFrameworkEvent(this.systemBundle, 1, null);
    }

    public void stopFramework() {
        Runnable stopcmd = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicInteger atomicInteger = OSGiBundleManager.this.stopMonitor;
                synchronized (atomicInteger) {
                    if (OSGiBundleManager.this.systemBundle.getState() != 32) {
                        return;
                    }
                    OSGiBundleManager.this.systemBundle.changeState(16);
                }
                StartLevelPlugin startLevel = OSGiBundleManager.this.getOptionalPlugin(StartLevelPlugin.class);
                if (startLevel != null) {
                    startLevel.decreaseStartLevel(0);
                } else {
                    for (AbstractBundleState bundleState : OSGiBundleManager.this.getBundles()) {
                        if (bundleState == OSGiBundleManager.this.systemBundle) continue;
                        try {
                            bundleState.stop();
                        }
                        catch (Exception ex) {
                            OSGiBundleManager.this.fireError(bundleState, "stopping bundle", ex);
                        }
                    }
                }
                ArrayList reverseServicePlugins = new ArrayList(OSGiBundleManager.this.plugins.values());
                Collections.reverse(reverseServicePlugins);
                for (Plugin plugin : reverseServicePlugins) {
                    if (!(plugin instanceof ServicePlugin)) continue;
                    ServicePlugin servicePlugin = (ServicePlugin)plugin;
                    servicePlugin.stopService();
                }
                FrameworkEventsPlugin eventsPlugin = OSGiBundleManager.this.getPlugin(FrameworkEventsPlugin.class);
                eventsPlugin.setActive(false);
                OSGiBundleManager.this.systemBundle.changeState(4);
                OSGiBundleManager.this.systemBundle.destroyBundleContext();
                AtomicInteger atomicInteger2 = OSGiBundleManager.this.stopMonitor;
                synchronized (atomicInteger2) {
                    OSGiBundleManager.this.stopMonitor.notifyAll();
                }
            }
        };
        this.executor.execute(stopcmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        AtomicInteger atomicInteger = this.stopMonitor;
        synchronized (atomicInteger) {
            int state = this.systemBundle.getState();
            if (state != 8 && state != 32 && state != 16) {
                return new FrameworkEvent(64, (Bundle)this.systemBundle, null);
            }
            this.stopMonitor.wait(timeout);
        }
        if (this.systemBundle.getState() != 4) {
            return new FrameworkEvent(512, (Bundle)this.systemBundle, null);
        }
        return new FrameworkEvent(64, (Bundle)this.systemBundle, null);
    }

    public void restartFramework() {
        OSGiSystemState systemBundle = this.getSystemBundle();
        if (systemBundle.getState() != 32) {
            return;
        }
        for (AbstractBundleState bundleState : this.getBundles()) {
            if (bundleState == systemBundle || bundleState.getState() != 32) continue;
            try {
                bundleState.stop();
            }
            catch (Throwable t) {
                this.fireWarning(bundleState, "stopping bundle", t);
            }
            try {
                bundleState.start();
            }
            catch (Throwable t) {
                this.fireError(bundleState, "starting bundle", t);
            }
        }
    }

    private URL getLocationURL(String location) throws BundleException {
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (url == null) {
            try {
                File file = new File(location);
                if (file.exists()) {
                    url = file.toURI().toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (url == null) {
            throw new BundleException("Unable to handle location=" + location);
        }
        return url;
    }

    void fireError(Bundle bundle, String context, Throwable t) {
        FrameworkEventsPlugin plugin = this.getPlugin(FrameworkEventsPlugin.class);
        if (t instanceof BundleException) {
            plugin.fireFrameworkEvent(bundle, 2, t);
        } else if (bundle != null) {
            plugin.fireFrameworkEvent(bundle, 2, new BundleException("Error " + context + " bundle: " + bundle, t));
        } else {
            plugin.fireFrameworkEvent(this.systemBundle, 2, new BundleException("Error " + context, t));
        }
    }

    void fireWarning(Bundle bundle, String context, Throwable t) {
        FrameworkEventsPlugin plugin = this.getPlugin(FrameworkEventsPlugin.class);
        if (t instanceof BundleException) {
            plugin.fireFrameworkEvent(bundle, 16, t);
        } else if (bundle != null) {
            plugin.fireFrameworkEvent(bundle, 16, new BundleException("Error " + context + " bundle: " + bundle, t));
        } else {
            plugin.fireFrameworkEvent(this.systemBundle, 16, new BundleException("Error " + context, t));
        }
    }
}

